/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;

public class Updater {
    public static void checkUpdates() {
        if (!Updater.isUpToDate()) {
            Logger.getLogger("CurrenciesAPI").warning("The framework is not up to date, the latest version is " + Updater.fetchLatestVersion());
        }
    }

    public static String getVersion() {
        Properties prop = new Properties();
        try {
            prop.load(Updater.class.getClassLoader().getResourceAsStream("currenciesapi.properties"));
            return prop.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isUpToDate() {
        try {
            String latestVersion = Updater.fetchLatestVersion();
            return Updater.getVersion().equals(latestVersion);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String fetchLatestVersion() {
        try {
            URL url = URI.create("https://api.github.com/repos/Traqueur-dev/CurrenciesAPI/releases/latest").toURL();
            String responseString = Updater.getString(url);
            int tagNameIndex = responseString.indexOf("\"tag_name\"");
            int start = responseString.indexOf(34, tagNameIndex + 10) + 1;
            int end = responseString.indexOf(34, start);
            return responseString.substring(start, end);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getString(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (Scanner scanner = new Scanner(connection.getInputStream());){
            while (scanner.hasNext()) {
                response.append(scanner.nextLine());
            }
        }
        finally {
            connection.disconnect();
        }
        return response.toString();
    }
}

