/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies.providers;

import fr.maxlego08.menu.hooks.currencies.CurrencyProvider;
import java.math.BigDecimal;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ExperienceProvider
implements CurrencyProvider {
    @Override
    public void deposit(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        if (offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            BigDecimal totalExperience = BigDecimal.valueOf(this.getTotalExperience(player));
            this.setTotalExperience(player, totalExperience.add(amount).intValue());
        }
    }

    @Override
    public void withdraw(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        if (offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            BigDecimal totalExperience = BigDecimal.valueOf(this.getTotalExperience(player));
            BigDecimal newExperience = totalExperience.subtract(amount);
            this.setTotalExperience(player, newExperience.max(BigDecimal.ZERO).intValue());
        }
    }

    @Override
    public BigDecimal getBalance(OfflinePlayer offlinePlayer) {
        if (offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            return player == null ? BigDecimal.ZERO : BigDecimal.valueOf(this.getTotalExperience(player));
        }
        return BigDecimal.ZERO;
    }

    private void setTotalExperience(Player player, int experience) {
        if (experience < 0) {
            throw new IllegalArgumentException("Experience is negative!");
        }
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        int currentExperience = experience;
        while (currentExperience > 0) {
            int j = this.getExpAtLevel(player);
            if ((currentExperience -= j) >= 0) {
                player.giveExp(j);
                continue;
            }
            player.giveExp(currentExperience += j);
            currentExperience = 0;
        }
    }

    private int getExpAtLevel(Player player) {
        return this.getExpAtLevel(player.getLevel());
    }

    private int getExpAtLevel(int experience) {
        if (experience <= 15) {
            return 2 * experience + 7;
        }
        if (experience <= 30) {
            return 5 * experience - 38;
        }
        return 9 * experience - 158;
    }

    private int getTotalExperience(Player player) {
        int experience = Math.round((float)this.getExpAtLevel(player) * player.getExp());
        int playerLevel = player.getLevel();
        while (playerLevel > 0) {
            experience += this.getExpAtLevel(--playerLevel);
        }
        if (experience < 0) {
            experience = Integer.MAX_VALUE;
        }
        return experience;
    }
}

