/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies.providers;

import dev.unnm3d.rediseconomy.api.RedisEconomyAPI;
import dev.unnm3d.rediseconomy.currency.Currency;
import fr.maxlego08.menu.hooks.currencies.CurrencyProvider;
import java.math.BigDecimal;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class RedisEconomyProvider
implements CurrencyProvider {
    private final String economyName;

    public RedisEconomyProvider(String economyName) {
        this.economyName = economyName;
    }

    private Currency getCurrency() {
        RedisEconomyAPI api = RedisEconomyAPI.getAPI();
        if (api == null) {
            Bukkit.getLogger().info("RedisEconomyAPI not found!");
            return null;
        }
        Currency currency = api.getCurrencyByName(this.economyName);
        if (currency == null) {
            Bukkit.getLogger().info("Currency " + this.economyName + " not found!");
        }
        return currency;
    }

    @Override
    public void deposit(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        Currency currency = this.getCurrency();
        if (currency != null) {
            currency.depositPlayer(offlinePlayer, amount.doubleValue());
        }
    }

    @Override
    public void withdraw(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        Currency currency = this.getCurrency();
        if (currency != null) {
            currency.withdrawPlayer(offlinePlayer, amount.doubleValue());
        }
    }

    @Override
    public BigDecimal getBalance(OfflinePlayer offlinePlayer) {
        Currency currency = this.getCurrency();
        return currency != null ? BigDecimal.valueOf(currency.getBalance(offlinePlayer)) : BigDecimal.ZERO;
    }
}

