/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies.providers;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.menu.hooks.currencies.CurrencyProvider;
import java.math.BigDecimal;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class ZEssentialsProvider
implements CurrencyProvider {
    private EconomyManager economyManager;
    private Economy economy;
    private final String economyName;

    public ZEssentialsProvider(String economyName) {
        this.economyName = economyName;
    }

    private void initialize() {
        if (this.economyManager == null || this.economy == null) {
            EssentialsPlugin essentialsPlugin = (EssentialsPlugin)Bukkit.getPluginManager().getPlugin("zEssentials");
            this.economyManager = essentialsPlugin.getEconomyManager();
            Optional optional = this.economyManager.getEconomy(this.economyName);
            if (optional.isPresent()) {
                this.economy = (Economy)optional.get();
            } else {
                throw new NullPointerException("ZEssentials economy " + this.economyName + " not found");
            }
        }
    }

    @Override
    public void deposit(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        this.initialize();
        this.economyManager.deposit(offlinePlayer.getUniqueId(), this.economy, amount, reason);
    }

    @Override
    public void withdraw(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        this.initialize();
        this.economyManager.withdraw(offlinePlayer.getUniqueId(), this.economy, amount, reason);
    }

    @Override
    public BigDecimal getBalance(OfflinePlayer offlinePlayer) {
        this.initialize();
        return this.economyManager.getBalance(offlinePlayer, this.economy);
    }
}

