/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.dialogs.loader.builder.input;

import fr.maxlego08.menu.api.button.dialogs.InputButton;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.enums.DialogInputType;
import fr.maxlego08.menu.hooks.dialogs.ZDialogManager;
import fr.maxlego08.menu.hooks.dialogs.utils.BuilderHelper;
import fr.maxlego08.menu.hooks.dialogs.utils.loader.DialogInputBuilderInt;
import fr.maxlego08.menu.zcore.logger.Logger;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class DialogInputTextBuilder
extends BuilderHelper
implements DialogInputBuilderInt {
    private final ZDialogManager dialogManager;

    public DialogInputTextBuilder(ZDialogManager dialogManager) {
        this.dialogManager = dialogManager;
    }

    @Override
    public DialogInputType getBodyType() {
        return DialogInputType.TEXT;
    }

    @Override
    public DialogInput build(Player player, InputButton button) {
        String key = button.getKey();
        int width = button.getWidth();
        String label = this.papi(button.getLabel(), player);
        boolean labelVisible = button.isLabelVisible();
        Optional<String> defaultTextSupplier = button.getDefaultTextSupplier();
        String defaultText = defaultTextSupplier.isPresent() ? this.papi(defaultTextSupplier.get(), player) : this.papi(button.getDefaultText(), player);
        int maxLength = button.getMaxLength();
        int multilineMaxLines = button.getMultilineMaxLines();
        int multilineHeight = button.getMultilineHeight();
        TextDialogInput.MultilineOptions multilineOptions = null;
        if (multilineMaxLines > 0 && multilineHeight > 0) {
            multilineOptions = TextDialogInput.MultilineOptions.create((Integer)multilineMaxLines, (Integer)multilineHeight);
        }
        if (defaultText.length() > maxLength) {
            if (Config.enableInformationMessage) {
                Logger.info("The default text of the text input is longer than the maximum length. Truncating to fit the maximum length.");
            }
            defaultText = defaultText.substring(0, maxLength);
        }
        return DialogInput.text((String)key, (int)width, (Component)this.dialogManager.getPaperComponent().getComponent(label), (boolean)labelVisible, (String)defaultText, (int)maxLength, (TextDialogInput.MultilineOptions)multilineOptions);
    }
}

