/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah;

import fr.maxlego08.menu.hooks.sarah.database.DatabaseType;
import java.util.Objects;

public class DatabaseConfiguration {
    private final String tablePrefix;
    private final String user;
    private final String password;
    private final int port;
    private final String host;
    private final String database;
    private final boolean debug;
    private final DatabaseType databaseType;

    public DatabaseConfiguration(String tablePrefix, String user, String password, int port, String host, String database, boolean debug, DatabaseType databaseType) {
        this.tablePrefix = tablePrefix;
        this.user = user;
        this.password = password;
        this.port = port;
        this.host = host;
        this.database = database;
        this.debug = debug;
        this.databaseType = databaseType;
    }

    public static DatabaseConfiguration create(String user, String password, int port, String host, String database, DatabaseType databaseType) {
        return new DatabaseConfiguration(null, user, password, port, host, database, false, databaseType);
    }

    public static DatabaseConfiguration create(String user, String password, int port, String host, String database) {
        return new DatabaseConfiguration(null, user, password, port, host, database, false, DatabaseType.MYSQL);
    }

    public static DatabaseConfiguration createMariaDb(String user, String password, int port, String host, String database) {
        return new DatabaseConfiguration(null, user, password, port, host, database, false, DatabaseType.MARIADB);
    }

    public static DatabaseConfiguration create(String user, String password, int port, String host, String database, boolean debug) {
        return new DatabaseConfiguration(null, user, password, port, host, database, debug, DatabaseType.MYSQL);
    }

    public static DatabaseConfiguration createMariaDb(String user, String password, int port, String host, String database, boolean debug) {
        return new DatabaseConfiguration(null, user, password, port, host, database, debug, DatabaseType.MARIADB);
    }

    public static DatabaseConfiguration create(String user, String password, String host, String database, DatabaseType databaseType) {
        return new DatabaseConfiguration(null, user, password, 3306, host, database, false, databaseType);
    }

    public static DatabaseConfiguration create(String user, String password, int port, String host, String database, boolean debug, DatabaseType databaseType) {
        return new DatabaseConfiguration(null, user, password, port, host, database, debug, databaseType);
    }

    public static DatabaseConfiguration createMariaDb(String user, String password, String host, String database) {
        return new DatabaseConfiguration(null, user, password, 3306, host, database, false, DatabaseType.MARIADB);
    }

    public static DatabaseConfiguration sqlite(boolean debug) {
        return new DatabaseConfiguration(null, null, null, 0, null, null, debug, DatabaseType.SQLITE);
    }

    public String replacePrefix(String tableName) {
        return this.tablePrefix == null ? tableName : tableName.replaceAll("%prefix%", this.tablePrefix);
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseConfiguration that = (DatabaseConfiguration)o;
        return this.port == that.port && this.debug == that.debug && Objects.equals(this.tablePrefix, that.tablePrefix) && Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.host, that.host) && Objects.equals(this.database, that.database) && this.databaseType == that.databaseType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tablePrefix, this.user, this.password, this.port, this.host, this.database, this.debug, this.databaseType});
    }

    public String toString() {
        return "DatabaseConfiguration{tablePrefix='" + this.tablePrefix + '\'' + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", port=" + this.port + ", host='" + this.host + '\'' + ", database='" + this.database + '\'' + ", debug=" + this.debug + ", databaseType=" + (Object)((Object)this.databaseType) + '}';
    }
}

