/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah.database;

import fr.maxlego08.menu.hooks.sarah.DatabaseConnection;
import fr.maxlego08.menu.hooks.sarah.conditions.ColumnDefinition;
import fr.maxlego08.menu.hooks.sarah.conditions.JoinCondition;
import fr.maxlego08.menu.hooks.sarah.conditions.SelectCondition;
import fr.maxlego08.menu.hooks.sarah.conditions.WhereCondition;
import fr.maxlego08.menu.hooks.sarah.database.Migration;
import fr.maxlego08.menu.hooks.sarah.database.SchemaType;
import fr.maxlego08.menu.hooks.sarah.logger.Logger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface Schema {
    public Schema uuid(String var1);

    public Schema uuid(String var1, UUID var2);

    public Schema string(String var1, int var2);

    public Schema text(String var1);

    public Schema longText(String var1);

    public Schema decimal(String var1);

    public Schema decimal(String var1, int var2, int var3);

    public Schema string(String var1, String var2);

    public Schema decimal(String var1, Number var2);

    public Schema date(String var1, Date var2);

    public Schema bigInt(String var1);

    public Schema integer(String var1);

    public Schema bigInt(String var1, long var2);

    public Schema object(String var1, Object var2);

    public Schema bool(String var1);

    public Schema bool(String var1, boolean var2);

    public Schema json(String var1);

    public Schema blob(String var1);

    public Schema blob(String var1, byte[] var2);

    public Schema blob(String var1, Object var2);

    public Schema primary();

    public Schema foreignKey(String var1);

    public Schema foreignKey(String var1, String var2, boolean var3);

    public Schema createdAt();

    public Schema updatedAt();

    public Schema timestamps();

    public Schema timestamp(String var1);

    public Schema autoIncrement(String var1);

    public Schema autoIncrementBigInt(String var1);

    public Schema nullable();

    public Schema unique();

    public Schema unique(boolean var1);

    public Schema defaultValue(Object var1);

    public Schema defaultCurrentTimestamp();

    public Schema where(String var1, Object var2);

    public Schema where(String var1, UUID var2);

    public Schema where(String var1, String var2, Object var3);

    public Schema where(String var1, String var2, String var3, Object var4);

    public Schema whereNotNull(String var1);

    public Schema whereNull(String var1);

    public Schema whereIn(String var1, Object ... var2);

    public Schema whereIn(String var1, List<String> var2);

    public Schema whereIn(String var1, String var2, Object ... var3);

    public Schema whereIn(String var1, String var2, List<String> var3);

    public Schema leftJoin(String var1, String var2, String var3, String var4, String var5);

    public Schema leftJoin(String var1, String var2, String var3, String var4, String var5, JoinCondition var6);

    public Schema rightJoin(String var1, String var2, String var3, String var4, String var5);

    public Schema innerJoin(String var1, String var2, String var3, String var4, String var5);

    public Schema fullJoin(String var1, String var2, String var3, String var4, String var5);

    public int execute(DatabaseConnection var1, Logger var2) throws SQLException;

    public List<Map<String, Object>> executeSelect(DatabaseConnection var1, Logger var2) throws SQLException;

    public long executeSelectCount(DatabaseConnection var1, Logger var2) throws SQLException;

    public <T> List<T> executeSelect(Class<T> var1, DatabaseConnection var2, Logger var3) throws Exception;

    public Migration getMigration();

    public void setMigration(Migration var1);

    public String getTableName();

    public void whereConditions(StringBuilder var1);

    public void applyWhereConditions(PreparedStatement var1, int var2) throws SQLException;

    public List<ColumnDefinition> getColumns();

    public List<String> getPrimaryKeys();

    public List<String> getForeignKeys();

    public List<JoinCondition> getJoinConditions();

    public void orderBy(String var1);

    public void orderByDesc(String var1);

    public String getOrderBy();

    public void distinct();

    public boolean isDistinct();

    public void addSelect(String var1);

    public void addSelect(String var1, String var2);

    public void addSelect(String var1, String var2, String var3);

    public void addSelect(String var1, String var2, String var3, Object var4);

    public SchemaType getSchemaType();

    public Schema addColumn(ColumnDefinition var1);

    public List<WhereCondition> getWhereConditions();

    public List<SelectCondition> getSelectColumns();

    public String getNewTableName();
}

