/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah.requests;

import fr.maxlego08.menu.hooks.sarah.DatabaseConfiguration;
import fr.maxlego08.menu.hooks.sarah.DatabaseConnection;
import fr.maxlego08.menu.hooks.sarah.database.Executor;
import fr.maxlego08.menu.hooks.sarah.database.Schema;
import fr.maxlego08.menu.hooks.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DeleteRequest
implements Executor {
    private final Schema schemaBuilder;

    public DeleteRequest(Schema schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(this.schemaBuilder.getTableName());
        this.schemaBuilder.whereConditions(sql);
        String finalQuery = databaseConfiguration.replacePrefix(sql.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block15: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    int result;
                    this.schemaBuilder.applyWhereConditions(preparedStatement, 1);
                    n = result = preparedStatement.executeUpdate();
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

