/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah.requests;

import fr.maxlego08.menu.hooks.sarah.DatabaseConfiguration;
import fr.maxlego08.menu.hooks.sarah.DatabaseConnection;
import fr.maxlego08.menu.hooks.sarah.database.Executor;
import fr.maxlego08.menu.hooks.sarah.database.Schema;
import fr.maxlego08.menu.hooks.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DropTableRequest
implements Executor {
    private final Schema schema;

    public DropTableRequest(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        String tableName = this.schema.getTableName();
        if (tableName == null || tableName.trim().isEmpty()) {
            logger.info("Invalid table name.");
            return -1;
        }
        String finalQuery = databaseConfiguration.replacePrefix("DROP TABLE IF EXISTS " + tableName);
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block16: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    preparedStatement.execute();
                    n = 0;
                    if (preparedStatement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            logger.info("Error while executing SQL query: " + exception.getMessage());
            return -1;
        }
    }
}

