/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.sarah.requests;

import fr.maxlego08.menu.hooks.sarah.DatabaseConfiguration;
import fr.maxlego08.menu.hooks.sarah.DatabaseConnection;
import fr.maxlego08.menu.hooks.sarah.conditions.ColumnDefinition;
import fr.maxlego08.menu.hooks.sarah.database.DatabaseType;
import fr.maxlego08.menu.hooks.sarah.database.Executor;
import fr.maxlego08.menu.hooks.sarah.database.Schema;
import fr.maxlego08.menu.hooks.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpsertRequest
implements Executor {
    private final Schema schema;

    public UpsertRequest(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        String upsertQuery;
        DatabaseType databaseType = databaseConfiguration.getDatabaseType();
        StringBuilder insertQuery = new StringBuilder("INSERT INTO " + this.schema.getTableName() + " (");
        StringBuilder valuesQuery = new StringBuilder("VALUES (");
        StringBuilder onUpdateQuery = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.schema.getColumns().size(); ++i) {
            ColumnDefinition columnDefinition = this.schema.getColumns().get(i);
            insertQuery.append(i > 0 ? ", " : "").append(columnDefinition.getSafeName());
            valuesQuery.append(i > 0 ? ", " : "").append("?");
            if (i > 0) {
                onUpdateQuery.append(", ");
            }
            if (databaseType == DatabaseType.SQLITE) {
                onUpdateQuery.append(columnDefinition.getSafeName()).append(" = excluded.").append(columnDefinition.getSafeName());
            } else {
                onUpdateQuery.append(columnDefinition.getSafeName()).append(" = ?");
            }
            values.add(columnDefinition.getObject());
        }
        insertQuery.append(") ");
        valuesQuery.append(")");
        if (databaseType == DatabaseType.SQLITE) {
            StringBuilder onConflictQuery = new StringBuilder(" ON CONFLICT (");
            List<String> primaryKeys = this.schema.getPrimaryKeys();
            for (int i = 0; i < primaryKeys.size(); ++i) {
                onConflictQuery.append(i > 0 ? ", " : "").append(primaryKeys.get(i));
            }
            onConflictQuery.append(") DO UPDATE SET ");
            upsertQuery = insertQuery + valuesQuery.toString() + onConflictQuery + onUpdateQuery;
        } else {
            onUpdateQuery.insert(0, " ON DUPLICATE KEY UPDATE ");
            upsertQuery = insertQuery + valuesQuery.toString() + onUpdateQuery;
        }
        String finalQuery = databaseConfiguration.replacePrefix(upsertQuery);
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block25: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    int index = 1;
                    for (Object e : values) {
                        preparedStatement.setObject(index++, e);
                    }
                    if (databaseType != DatabaseType.SQLITE) {
                        for (Object e : values) {
                            preparedStatement.setObject(index++, e);
                        }
                    }
                    preparedStatement.executeUpdate();
                    n = preparedStatement.getUpdateCount();
                    if (preparedStatement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

