/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.requirement.data.ActionPlayerData;
import fr.maxlego08.menu.api.requirement.data.ActionPlayerDataType;
import fr.maxlego08.menu.api.storage.StorageManager;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.requirement.ZActionPlayerData;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ActionPlayerDataLoader
implements Loader<ActionPlayerData> {
    private final StorageManager storageManager;

    public ActionPlayerDataLoader(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public ActionPlayerData load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        ActionPlayerDataType type = ActionPlayerDataType.valueOf(configuration.getString(path + "type", "SET"));
        String key = configuration.getString(path + "key");
        Object object = configuration.get(path + "value", (Object)true);
        long seconds = configuration.getLong(path + "seconds", 0L);
        boolean mathExpression = configuration.getBoolean(path + "math", false);
        return new ZActionPlayerData(this.storageManager, key, type, object, seconds, mathExpression);
    }

    @Override
    public void save(ActionPlayerData object, YamlConfiguration configuration, String path, File file, Object ... objects) {
        configuration.set(path + "type", (Object)"SET");
        configuration.set(path + "key", (Object)object.getKey());
        configuration.set(path + "value", object.getValue());
        configuration.set(path + "seconds", (Object)object.getSeconds());
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

