/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.ZInventory;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryOption;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.exceptions.InventorySizeException;
import fr.maxlego08.menu.api.exceptions.InventoryTypeException;
import fr.maxlego08.menu.api.itemstack.ItemStackSimilar;
import fr.maxlego08.menu.api.pattern.Pattern;
import fr.maxlego08.menu.api.pattern.PatternManager;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.api.utils.OpenWithItem;
import fr.maxlego08.menu.itemstack.FullSimilar;
import fr.maxlego08.menu.loader.MenuItemStackLoader;
import fr.maxlego08.menu.loader.RequirementLoader;
import fr.maxlego08.menu.loader.ZButtonLoader;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;

public class InventoryLoader
extends ZUtils
implements Loader<Inventory> {
    private final ZMenuPlugin plugin;

    public InventoryLoader(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Inventory load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        ZInventory inventory;
        int size;
        InventoryType inventoryType;
        File file = (File)objects[0];
        String name = configuration.getString("name", configuration.getString("title"));
        name = name == null ? "" : name;
        String nameType = configuration.getString("type", "CHEST").toUpperCase();
        try {
            inventoryType = InventoryType.valueOf((String)nameType);
            if (inventoryType == InventoryType.CRAFTING || inventoryType == InventoryType.PLAYER) {
                throw new InventoryTypeException("Type Inventory " + nameType + " can't use for the moment for inventory " + file.getAbsolutePath());
            }
            size = inventoryType.getDefaultSize();
        }
        catch (IllegalArgumentException exception) {
            throw new InventoryTypeException("Type Inventory " + nameType + " is not valid for inventory " + file.getAbsolutePath());
        }
        if (inventoryType == InventoryType.CHEST && (size = configuration.getInt("size", 54)) % 9 != 0) {
            throw new InventorySizeException("Size " + size + " is not valid for inventory " + file.getAbsolutePath());
        }
        Map<Character, List<Integer>> matrix = this.generateMatrix(configuration.getStringList("matrix"));
        if (!matrix.isEmpty()) {
            size = this.getInventorySizeByMatrix(configuration.getStringList("matrix"));
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        ZButtonLoader loader = new ZButtonLoader(this.plugin, file, size, matrix);
        MenuItemStackLoader menuItemStackLoader = new MenuItemStackLoader(this.plugin.getInventoryManager());
        ConfigurationSection section = configuration.getConfigurationSection("items.");
        if (section != null) {
            for (String buttonPath : section.getKeys(false)) {
                try {
                    buttons.add((Button)loader.load(configuration, "items." + buttonPath + ".", buttonPath));
                }
                catch (Exception exception) {
                    Logger.info(exception.getMessage(), Logger.LogType.ERROR);
                }
            }
        } else if (Config.enableDebug) {
            Logger.info("items section was not found in " + file.getAbsolutePath(), Logger.LogType.ERROR);
        }
        String fileName = this.getFileNameWithoutExtension(file);
        try {
            Class classz = (Class)objects[1];
            Constructor constructor = classz.getDeclaredConstructor(Plugin.class, String.class, String.class, Integer.TYPE, List.class);
            Plugin plugin = (Plugin)objects[2];
            inventory = (ZInventory)constructor.newInstance(plugin, name, fileName, size, buttons);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            inventory = new ZInventory(this.plugin, name, fileName, size, buttons);
        }
        inventory.setType(inventoryType);
        inventory.setUpdateInterval(configuration.getInt(path + "update-interval", configuration.getInt(path + "updateInterval", 1000)));
        inventory.setClearInventory(configuration.getBoolean(path + "clear-inventory", configuration.getBoolean(path + "clearInventory", false)));
        inventory.setCancelItemPickup(configuration.getBoolean(path + "cancel-item-pickup", configuration.getBoolean(path + "cancelItemPickup", false)));
        inventory.setTargetPlayerNamePlaceholder(configuration.getString(path + "target-player-name-placeholder", configuration.getString(path + "target_player_name_placeholder", "%player_name%")));
        inventory.setFile(file);
        this.loadFillItem(configuration, inventory, menuItemStackLoader, file);
        this.loadPatterns(configuration, inventory);
        this.loadOpenWithItem(configuration, inventory, file, menuItemStackLoader);
        this.loadOpenRequirement(configuration, inventory, file);
        ArrayList<InventoryOption> inventoryOptions = new ArrayList<InventoryOption>();
        for (Map.Entry<Plugin, List<Class<? extends InventoryOption>>> entry : this.plugin.getInventoryManager().getInventoryOptions().entrySet()) {
            for (Class<? extends InventoryOption> optionClass : entry.getValue()) {
                InventoryOption instance = this.createInstance(entry.getKey(), optionClass);
                if (instance == null) continue;
                inventoryOptions.add(instance);
            }
        }
        for (InventoryOption inventoryOption : inventoryOptions) {
            inventoryOption.loadInventory(inventory, file, configuration, this.plugin.getInventoryManager(), this.plugin.getButtonManager());
        }
        return inventory;
    }

    private void loadFillItem(YamlConfiguration configuration, ZInventory inventory, Loader<MenuItemStack> menuItemStackLoader, File file) {
        try {
            String loadString;
            String string = configuration.contains("fillItem") ? "fillItem" : (loadString = configuration.contains("fill-item") ? "fill-item" : null);
            if (loadString != null) {
                inventory.setFillItemStack(menuItemStackLoader.load(configuration, loadString + ".", file));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadPatterns(YamlConfiguration configuration, ZInventory inventory) {
        PatternManager patternManager = this.plugin.getPatternManager();
        List patternNames = configuration.getStringList("patterns");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternNames.size());
        for (String patternName : patternNames) {
            Optional<Pattern> pattern = patternManager.getPattern(patternName);
            pattern.ifPresent(patterns::add);
        }
        inventory.setPatterns(patterns);
    }

    private void loadOpenWithItem(YamlConfiguration configuration, ZInventory inventory, File file, Loader<MenuItemStack> menuItemStackLoader) {
        try {
            String loadString;
            String string = configuration.contains("openWithItem") ? "openWithItem" : (loadString = configuration.contains("open-with-item") ? "open-with-item" : null);
            if (loadString != null) {
                MenuItemStack loadedItem = menuItemStackLoader.load(configuration, loadString + ".item.", file);
                List actionStrings = configuration.getStringList(loadString + ".actions");
                ArrayList<Action> actions = new ArrayList<Action>(actionStrings.size());
                for (String string2 : actionStrings) {
                    try {
                        actions.add(Action.valueOf((String)string2.toUpperCase()));
                    }
                    catch (Exception exception) {}
                }
                String type = configuration.getString(loadString + ".type", "full");
                ItemStackSimilar itemStackSimilar = this.plugin.getInventoryManager().getItemStackVerification(type).orElseGet(FullSimilar::new);
                inventory.setOpenWithItem(new OpenWithItem(loadedItem, actions, itemStackSimilar));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadOpenRequirement(YamlConfiguration configuration, ZInventory inventory, File file) throws InventoryException {
        String loadString;
        String string = configuration.contains("open_requirement") ? "open_requirement" : (loadString = configuration.contains("open-requirement") ? "open-requirement" : null);
        if (loadString != null && configuration.contains(loadString) && configuration.isConfigurationSection(loadString + ".")) {
            RequirementLoader requirementLoader = new RequirementLoader(this.plugin);
            inventory.setOpenRequirement((Requirement)requirementLoader.load(configuration, loadString + ".", file));
        }
    }

    private InventoryOption createInstance(Plugin plugin, Class<? extends InventoryOption> aClass) {
        try {
            Constructor<? extends InventoryOption> constructor = aClass.getConstructor(Plugin.class);
            return constructor.newInstance(plugin);
        }
        catch (NoSuchMethodException ignored) {
            try {
                return aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return null;
            }
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public void save(Inventory object, YamlConfiguration configuration, String path, File file, Object ... objects) {
        MenuItemStackLoader itemStackLoader = new MenuItemStackLoader(this.plugin.getInventoryManager());
        configuration.set("name", (Object)object.getName());
        configuration.set("size", (Object)object.size());
        if (object.getFillItemStack() != null) {
            itemStackLoader.save(object.getFillItemStack(), configuration, "fill-item.", file, new Object[0]);
        }
    }
}

