/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.api.utils.OpenLink;
import fr.maxlego08.menu.zcore.utils.ZOpenLink;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.configuration.file.YamlConfiguration;

public class OpenLinkLoader
implements Loader<OpenLink> {
    private final MenuPlugin plugin;

    public OpenLinkLoader(MenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public OpenLink load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        ClickEvent.Action action = ClickEvent.Action.valueOf((String)configuration.getString(path + "action", "OPEN_URL").toUpperCase());
        String link = configuration.getString(path + "link");
        String message = configuration.getString(path + "message");
        String replace = configuration.getString(path + "replace");
        List hover = configuration.getStringList(path + "hover");
        return new ZOpenLink(this.plugin, action, message, link, replace, hover);
    }

    @Override
    public void save(OpenLink object, YamlConfiguration configuration, String path, File file, Object ... objects) {
        configuration.set(path + "action", (Object)"OPEN_URL");
        configuration.set(path + "link", (Object)object.getLink());
        configuration.set(path + "message", (Object)object.getMessage());
        configuration.set(path + "replace", (Object)object.getReplace());
        configuration.set(path + "hover", object.getHover());
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

