/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.requirement.ZRequirement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.ClickType;

public class RequirementLoader
implements Loader<Requirement> {
    private final MenuPlugin plugin;

    public RequirementLoader(MenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Requirement load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        File file = (File)objects[0];
        ButtonManager buttonManager = this.plugin.getButtonManager();
        List<Permissible> permissibles = buttonManager.loadPermissible(configuration.getList(path + "requirements", configuration.getList(path + "requirement", new ArrayList())), path, file);
        List<Action> successActions = buttonManager.loadActions(configuration.getList(path + "success", new ArrayList()), path + "success", file);
        List<Action> denyActions = buttonManager.loadActions(configuration.getList(path + "deny", new ArrayList()), path + "deny", file);
        List<ClickType> clickTypes = this.plugin.getInventoryManager().loadClicks(configuration.getStringList(path + "clicks"));
        int miniumRequirement = configuration.getInt(path + "minimumRequirement", configuration.getInt(path + "minimum-requirement", permissibles.size()));
        return new ZRequirement(miniumRequirement, permissibles, denyActions, successActions, clickTypes);
    }

    @Override
    public void save(Requirement object, YamlConfiguration configuration, String path, File file, Object ... objects) {
    }
}

