/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader.deluxemenu;

import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.command.CommandManager;
import fr.maxlego08.menu.api.enums.ItemVerification;
import fr.maxlego08.menu.api.enums.PlaceholderAction;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.sound.SoundOption;
import fr.maxlego08.menu.hooks.currencies.Currencies;
import fr.maxlego08.menu.hooks.xseries.XSound;
import fr.maxlego08.menu.requirement.actions.BroadcastAction;
import fr.maxlego08.menu.requirement.actions.BroadcastSoundAction;
import fr.maxlego08.menu.requirement.actions.CloseAction;
import fr.maxlego08.menu.requirement.actions.ConnectAction;
import fr.maxlego08.menu.requirement.actions.ConsoleCommandAction;
import fr.maxlego08.menu.requirement.actions.CurrencyDepositAction;
import fr.maxlego08.menu.requirement.actions.CurrencyWithdrawAction;
import fr.maxlego08.menu.requirement.actions.InventoryAction;
import fr.maxlego08.menu.requirement.actions.MessageAction;
import fr.maxlego08.menu.requirement.actions.PlayerCommandAction;
import fr.maxlego08.menu.requirement.actions.RefreshAction;
import fr.maxlego08.menu.requirement.actions.SoundAction;
import fr.maxlego08.menu.requirement.permissible.ZCurrencyPermissible;
import fr.maxlego08.menu.requirement.permissible.ZItemPermissible;
import fr.maxlego08.menu.requirement.permissible.ZPermissionPermissible;
import fr.maxlego08.menu.requirement.permissible.ZPlaceholderPermissible;
import fr.maxlego08.menu.requirement.permissible.ZRegexPermissible;
import fr.maxlego08.menu.sound.ZSoundOption;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public abstract class DeluxeMenuCommandUtils
extends ZUtils {
    protected List<Action> loadActions(InventoryManager inventoryManager, CommandManager commandManager, Plugin plugin, List<String> commands) {
        ArrayList<Action> actions = new ArrayList<Action>();
        HashMap<String, Function<String, Action>> actionMap = new HashMap<String, Function<String, Action>>();
        actionMap.put("[close]", cmd -> new CloseAction());
        actionMap.put("[console]", cmd -> new ConsoleCommandAction(Collections.singletonList(this.removePrefix((String)cmd, "[console]"))));
        actionMap.put("[player]", cmd -> new PlayerCommandAction(Collections.singletonList(this.removePrefix((String)cmd, "[player]")), false));
        actionMap.put("[commandevent]", cmd -> new PlayerCommandAction(Collections.singletonList(this.removePrefix((String)cmd, "[commandevent]")), true));
        actionMap.put("[minimessage]", cmd -> new MessageAction(Collections.singletonList(this.removePrefix((String)cmd, "[minimessage]")), true));
        actionMap.put("[minibroadcast]", cmd -> new BroadcastAction(Collections.singletonList(this.removePrefix((String)cmd, "[minibroadcast]")), true, new ArrayList<Permissible>()));
        actionMap.put("[message]", cmd -> new MessageAction(Collections.singletonList(this.color(this.removePrefix((String)cmd, "[message]"))), false));
        actionMap.put("[broadcast]", cmd -> new BroadcastAction(Collections.singletonList(this.color(this.removePrefix((String)cmd, "[message]"))), false, new ArrayList<Permissible>()));
        actionMap.put("[openguimenu]", cmd -> new InventoryAction(inventoryManager, commandManager, this.removePrefix((String)cmd, "[openguimenu]"), "zMenu", "1", new ArrayList<String>()));
        actionMap.put("[openmenu]", cmd -> new InventoryAction(inventoryManager, commandManager, this.removePrefix((String)cmd, "[openmenu]"), "zMenu", "1", new ArrayList<String>()));
        actionMap.put("[connect]", cmd -> new ConnectAction(this.removePrefix((String)cmd, "[connect]"), plugin));
        actionMap.put("[refresh]", cmd -> new RefreshAction());
        actionMap.put("[broadcastsound]", cmd -> new BroadcastSoundAction(this.getSoundOption(this.removePrefix((String)cmd, "[broadcastsound]"))));
        actionMap.put("[broadcastsoundworld]", cmd -> new BroadcastSoundAction(this.getSoundOption(this.removePrefix((String)cmd, "[broadcastsoundworld]"))));
        actionMap.put("[sound]", cmd -> new SoundAction(this.getSoundOption(this.removePrefix((String)cmd, "[sound]"))));
        actionMap.put("[takemoney]", cmd -> new CurrencyWithdrawAction(this.removePrefix((String)cmd, "[takemoney]"), Currencies.VAULT, null, "no reason"));
        actionMap.put("[givemoney]", cmd -> new CurrencyDepositAction(this.removePrefix((String)cmd, "[givemoney]"), Currencies.VAULT, null, "no reason"));
        block0: for (String command : commands) {
            CommandDelayResult result = this.extractAndRemoveDelayAndChance(command);
            String cleanedCommand = result.command();
            int delay = result.delay();
            float chance = result.chance();
            for (Map.Entry entry : actionMap.entrySet()) {
                if (!cleanedCommand.startsWith((String)entry.getKey())) continue;
                String finalCommand = this.removePrefix(cleanedCommand, (String)entry.getKey());
                Action action = (Action)((Function)entry.getValue()).apply(finalCommand);
                if (delay > 0) {
                    action.setDelay(delay);
                }
                action.setChance(chance);
                actions.add(action);
                continue block0;
            }
        }
        return actions;
    }

    private CommandDelayResult extractAndRemoveDelayAndChance(String command) {
        Pattern delayPattern = Pattern.compile("<delay=(\\d+)>");
        Matcher matcher = delayPattern.matcher(command);
        int delay = 0;
        if (matcher.find()) {
            delay = Integer.parseInt(matcher.group(1));
            command = matcher.replaceFirst("").trim();
        }
        Pattern chancePattern = Pattern.compile("<chance=(\\d+(\\.\\d+)?)>");
        matcher = chancePattern.matcher(command);
        float chance = 100.0f;
        if (matcher.find()) {
            chance = Float.parseFloat(matcher.group(1));
            command = matcher.replaceFirst("").trim();
        }
        return new CommandDelayResult(command, delay, chance);
    }

    private String removePrefix(String command, String prefix) {
        return command.replace(prefix + " ", "").trim();
    }

    private SoundOption getSoundOption(String command) {
        String[] values = command.split(" ");
        if (values.length == 0) {
            return null;
        }
        String sound = values[0];
        float volume = values.length >= 2 ? Float.parseFloat(values[1]) : 1.0f;
        float pitch = values.length >= 3 ? Float.parseFloat(values[2]) : 1.0f;
        Optional<XSound> optionalXSound = sound == null || sound.isEmpty() ? Optional.empty() : XSound.of(sound);
        return optionalXSound.map(xSound -> new ZSoundOption((XSound)xSound, XSound.Category.MASTER.name(), null, volume, pitch, false)).orElseGet(() -> new ZSoundOption(null, XSound.Category.MASTER.name(), sound, volume, pitch, true));
    }

    protected List<Permissible> loadPermissibles(InventoryManager inventoryManager, CommandManager commandManager, Plugin plugin, ConfigurationSection configurationSection) {
        ArrayList<Permissible> permissibles = new ArrayList<Permissible>();
        for (String key : configurationSection.getKeys(false)) {
            Permissible permissible;
            ConfigurationSection requirementSection = configurationSection.getConfigurationSection(key);
            if (requirementSection == null || (permissible = this.loadPermissible(inventoryManager, commandManager, plugin, requirementSection)) == null) continue;
            permissibles.add(permissible);
        }
        return permissibles;
    }

    protected Permissible loadPermissible(InventoryManager inventoryManager, CommandManager commandManager, Plugin plugin, ConfigurationSection section) {
        String type = section.getString("type");
        if (type == null) {
            return null;
        }
        List<Action> denyActions = this.loadActions(inventoryManager, commandManager, plugin, section.getStringList("deny_commands"));
        String permission = section.getString("permission");
        switch (type.toLowerCase()) {
            case "has permission": 
            case "has perm": 
            case "haspermission": 
            case "hasperm": 
            case "perm": {
                return new ZPermissionPermissible(permission, denyActions, new ArrayList<Action>());
            }
            case "!has permission": 
            case "!has perm": 
            case "!haspermission": 
            case "!hasperm": 
            case "!perm": {
                return new ZPermissionPermissible("!" + permission, denyActions, new ArrayList<Action>());
            }
            case "string contains": 
            case "stringcontains": 
            case "contains": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.CONTAINS_STRING);
            }
            case "string equals": 
            case "stringequals": 
            case "equals": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.EQUALS_STRING);
            }
            case "stringequalsignorecase": 
            case "string equals ignorecase": 
            case "equalsignorecase": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.EQUALSIGNORECASE_STRING);
            }
            case ">": 
            case "greater than": 
            case "greaterthan": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.SUPERIOR);
            }
            case ">=": 
            case "greater than or equal to": 
            case "greaterthanorequalto": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.SUPERIOR_OR_EQUAL);
            }
            case "==": 
            case "equal to": 
            case "equalto": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.EQUAL_TO);
            }
            case "<=": 
            case "less than or equal to": 
            case "lessthanorequalto": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.LOWER_OR_EQUAL);
            }
            case "<": 
            case "less than": 
            case "lessthan": {
                return this.createPlaceholderPermissible(section, denyActions, PlaceholderAction.LOWER);
            }
            case "regex matches": 
            case "regex": {
                String input = section.getString("input");
                String regex = section.getString("regex");
                return new ZRegexPermissible(regex, input, denyActions, new ArrayList<Action>());
            }
            case "has money": 
            case "hasmoney": 
            case "money": {
                String amount = section.getString("amount");
                return new ZCurrencyPermissible(denyActions, new ArrayList<Action>(), Currencies.VAULT, amount, null);
            }
            case "has item": 
            case "item": 
            case "hasitem": {
                ZMenuItemStack menuItemStack = new ZMenuItemStack(inventoryManager, "", "");
                int amount = section.getInt("amount");
                menuItemStack.setMaterial(section.getString("material"));
                return new ZItemPermissible(menuItemStack, amount, denyActions, new ArrayList<Action>(), ItemVerification.SIMILAR);
            }
        }
        return null;
    }

    private ZPlaceholderPermissible createPlaceholderPermissible(ConfigurationSection section, List<Action> denyActions, PlaceholderAction action) {
        String input = section.getString("input");
        String output = section.getString("output");
        return new ZPlaceholderPermissible(action, input, output, null, denyActions, new ArrayList<Action>(), false);
    }

    private record CommandDelayResult(String command, int delay, float chance) {
    }
}

