/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader.permissible;

import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.loader.PermissibleLoader;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import fr.maxlego08.menu.api.utils.cuboid.Cuboid;
import fr.maxlego08.menu.api.utils.cuboid.Region;
import fr.maxlego08.menu.requirement.permissible.ZCuboidPermissible;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class CuboidPermissibleLoader
extends PermissibleLoader {
    private final ButtonManager buttonManager;

    public CuboidPermissibleLoader(ButtonManager buttonManager) {
        super("cuboid");
        this.buttonManager = buttonManager;
    }

    @Override
    public Permissible load(String path, TypedMapAccessor accessor, File file) {
        List<Action> denyActions = this.loadAction(this.buttonManager, accessor, "deny", path, file);
        List<Action> successActions = this.loadAction(this.buttonManager, accessor, "success", path, file);
        List<String> cuboids = accessor.getStringList("cuboids", new ArrayList<String>());
        if (cuboids.isEmpty()) {
            return new ZCuboidPermissible(denyActions, successActions, null);
        }
        ArrayList<Cuboid> cuboidList = new ArrayList<Cuboid>(cuboids.size());
        for (String cuboid : cuboids) {
            cuboidList.add(this.stringToCuboid(cuboid));
        }
        Region region = new Region(cuboidList);
        return new ZCuboidPermissible(denyActions, successActions, region);
    }

    private Cuboid stringToCuboid(String string) {
        String[] values = string.split(",");
        World world = Bukkit.getWorld((String)values[0]);
        Location first = new Location(world, Double.parseDouble(values[1]), Double.parseDouble(values[2]), Double.parseDouble(values[3]));
        Location second = new Location(world, Double.parseDouble(values[4]), Double.parseDouble(values[5]), Double.parseDouble(values[6]));
        return new Cuboid(first, second);
    }
}

