/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.mechanics.itemjoin;

import fr.maxlego08.menu.api.mechanic.Mechanic;
import fr.maxlego08.menu.api.mechanic.MechanicFactory;
import java.util.OptionalInt;
import org.bukkit.configuration.ConfigurationSection;

public class ItemJoinMechanic
extends Mechanic {
    private final boolean grantOnFirstJoin;
    private final boolean preventInventoryChanges;
    private final OptionalInt fixedSlot;

    public ItemJoinMechanic(String itemId, MechanicFactory mechanicFactory, ConfigurationSection mechanicSection) {
        super(itemId, mechanicFactory, mechanicSection);
        this.grantOnFirstJoin = mechanicSection.getBoolean("give-first-join", false);
        this.preventInventoryChanges = mechanicSection.getBoolean("prevent-inventory-modification", true);
        int slot = mechanicSection.getInt("fixed-slot", -1);
        this.fixedSlot = slot >= 0 && slot <= 36 ? OptionalInt.of(slot) : OptionalInt.empty();
    }

    public boolean shouldGrantOnFirstJoin() {
        return this.grantOnFirstJoin;
    }

    public boolean preventsInventoryChanges() {
        return this.preventInventoryChanges;
    }

    public OptionalInt getFixedSlot() {
        return this.fixedSlot;
    }
}

