/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.mechanics.itemjoin;

import fr.maxlego08.menu.api.ItemManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.mechanic.Mechanic;
import fr.maxlego08.menu.api.mechanic.MechanicListener;
import fr.maxlego08.menu.mechanics.itemjoin.ItemJoinMechanic;
import fr.maxlego08.menu.mechanics.itemjoin.ItemJoinMechanicFactory;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public class ItemJoinMechanicListener
extends MechanicListener {
    private final ItemJoinMechanicFactory itemJoinMechanicFactory;
    private final ItemManager itemManager;

    public ItemJoinMechanicListener(ItemJoinMechanicFactory itemJoinMechanicFactory, MenuPlugin plugin) {
        this.itemJoinMechanicFactory = itemJoinMechanicFactory;
        this.itemManager = plugin.getItemManager();
    }

    private Optional<ItemJoinMechanic> getProtectedMechanic(ItemStack item) {
        ItemJoinMechanic itemJoinMechanic;
        if (item == null) {
            return Optional.empty();
        }
        Optional<String> itemId = this.itemManager.getItemId(item);
        if (itemId.isEmpty()) {
            return Optional.empty();
        }
        Mechanic mechanic = this.itemJoinMechanicFactory.getMechanic(itemId.get());
        if (mechanic instanceof ItemJoinMechanic && (itemJoinMechanic = (ItemJoinMechanic)mechanic).preventsInventoryChanges() && itemJoinMechanic.getFixedSlot().isPresent()) {
            return Optional.of(itemJoinMechanic);
        }
        return Optional.empty();
    }

    private boolean isProtectedItem(ItemStack item) {
        return this.getProtectedMechanic(item).isPresent();
    }

    @EventHandler
    public void onConnect(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            for (Map.Entry<String, Mechanic> entry : this.itemJoinMechanicFactory.getAllMechanics()) {
                ItemJoinMechanic itemJoinMechanic;
                Mechanic mechanic = entry.getValue();
                if (!(mechanic instanceof ItemJoinMechanic) || !(itemJoinMechanic = (ItemJoinMechanic)mechanic).shouldGrantOnFirstJoin()) continue;
                this.itemManager.giveItem(player, entry.getKey());
            }
        }
    }

    @EventHandler
    public void onPlayerDrop(PlayerDropItemEvent event) {
        if (this.isProtectedItem(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getType() != InventoryType.CRAFTING) {
            return;
        }
        Optional<ItemJoinMechanic> mechanic = this.getProtectedMechanic(event.getCurrentItem());
        if (mechanic.isPresent() && event.getSlot() == mechanic.get().getFixedSlot().getAsInt()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (event.getInventory().getType() != InventoryType.CRAFTING) {
            return;
        }
        for (ItemStack draggedItem : event.getNewItems().values()) {
            Optional<ItemJoinMechanic> mechanic = this.getProtectedMechanic(draggedItem);
            if (!mechanic.isPresent() || !event.getRawSlots().contains(mechanic.get().getFixedSlot().getAsInt())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onSwapHand(PlayerSwapHandItemsEvent event) {
        if (this.isProtectedItem(event.getOffHandItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        ItemStack frameItem = frame.getItem();
        ItemStack itemInHand = event.getPlayer().getInventory().getItemInMainHand();
        if (frameItem.getType() == Material.AIR && itemInHand.getType() != Material.AIR && this.isProtectedItem(itemInHand)) {
            event.setCancelled(true);
        }
    }

    @Override
    public boolean onItemGive(Player player, ItemStack item, String itemId) {
        ItemJoinMechanic itemJoinMechanic;
        Mechanic mechanic = this.itemJoinMechanicFactory.getMechanic(itemId);
        if (mechanic instanceof ItemJoinMechanic && (itemJoinMechanic = (ItemJoinMechanic)mechanic).preventsInventoryChanges() && itemJoinMechanic.getFixedSlot().isPresent()) {
            int slot = itemJoinMechanic.getFixedSlot().getAsInt();
            player.getInventory().setItem(slot, item);
            return true;
        }
        return false;
    }
}

