/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.placeholder;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.interfaces.ReturnBiConsumer;
import fr.maxlego08.menu.placeholder.AutoPlaceholder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;

public class LocalPlaceholder {
    private static volatile LocalPlaceholder instance;
    private final String prefix = "zmenu";
    private final Pattern pattern = Pattern.compile("[%]" + this.prefix + "_([^%]+)[%]");
    private final List<AutoPlaceholder> autoPlaceholders = new ArrayList<AutoPlaceholder>();
    private MenuPlugin plugin;

    private LocalPlaceholder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalPlaceholder getInstance() {
        if (instance != null) return instance;
        Class<LocalPlaceholder> clazz = LocalPlaceholder.class;
        synchronized (LocalPlaceholder.class) {
            if (instance != null) return instance;
            instance = new LocalPlaceholder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(String startWith, ReturnBiConsumer<OfflinePlayer, String, String> biConsumer) {
        this.autoPlaceholders.add(new AutoPlaceholder(startWith, biConsumer));
    }

    public String setPlaceholders(OfflinePlayer offlinePlayer, String placeholder) {
        if (placeholder == null || !placeholder.contains("%")) {
            return placeholder;
        }
        Matcher matcher = this.pattern.matcher(placeholder);
        while (matcher.find()) {
            String stringPlaceholder = matcher.group(0);
            String regex = matcher.group(1);
            String replace = this.onRequest(offlinePlayer, regex);
            if (replace == null) continue;
            placeholder = placeholder.replace(stringPlaceholder, replace);
        }
        return placeholder;
    }

    public List<String> setPlaceholders(OfflinePlayer offlinePlayer, List<String> lore) {
        if (lore == null) {
            return null;
        }
        ArrayList<String> parsed = new ArrayList<String>(lore.size());
        for (String entry : lore) {
            parsed.add(this.setPlaceholders(offlinePlayer, entry));
        }
        return parsed;
    }

    public String onRequest(OfflinePlayer offlinePlayer, String string) {
        for (AutoPlaceholder autoPlaceholder : this.autoPlaceholders) {
            if (!string.startsWith(autoPlaceholder.startWith())) continue;
            String value = string.replace(autoPlaceholder.startWith(), "");
            return autoPlaceholder.accept(offlinePlayer, value);
        }
        return null;
    }

    public String getPrefix() {
        return "zmenu";
    }

    public MenuPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(MenuPlugin plugin) {
        this.plugin = plugin;
    }
}

