/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.placeholder;

import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.CompatibilityUtil;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.hooks.exp4j.ExpressionBuilder;
import fr.maxlego08.menu.inventory.inventories.InventoryDefault;
import fr.maxlego08.menu.placeholder.LocalPlaceholder;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.builder.TimerBuilder;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class MenuPlaceholders
extends ZUtils {
    public void register(MenuPlugin plugin) {
        LocalPlaceholder placeholder = LocalPlaceholder.getInstance();
        InventoryManager inventoryManager = plugin.getInventoryManager();
        placeholder.register("test", (a, b) -> "&ctest");
        placeholder.register("player_page", (player, s) -> String.valueOf(inventoryManager.getPage((OfflinePlayer)player)));
        placeholder.register("player_next_page", (player, s) -> String.valueOf(inventoryManager.getPage((OfflinePlayer)player) + 1));
        placeholder.register("player_previous_page", (player, s) -> String.valueOf(inventoryManager.getPage((OfflinePlayer)player) - 1));
        placeholder.register("player_max_page", (player, s) -> String.valueOf(inventoryManager.getMaxPage((OfflinePlayer)player)));
        placeholder.register("player_previous_inventories", (playeofflinePlayer, s) -> {
            if (playeofflinePlayer.isOnline()) {
                Player player = playeofflinePlayer.getPlayer();
                if (player == null) {
                    return "0";
                }
                InventoryHolder inventoryHolder = CompatibilityUtil.getTopInventory(player).getHolder();
                if (inventoryHolder instanceof InventoryDefault) {
                    InventoryDefault inventoryDefault = (InventoryDefault)inventoryHolder;
                    return String.valueOf(inventoryDefault.getOldInventories().size());
                }
            }
            return "0";
        });
        placeholder.register("math_", (player, args) -> String.valueOf(new ExpressionBuilder(plugin.parse((OfflinePlayer)player, args.replace("{", "%").replace("}", "%"))).build().evaluate()));
        placeholder.register("formatted_math_", (player, args) -> this.format(new ExpressionBuilder(plugin.parse((OfflinePlayer)player, args.replace("{", "%").replace("}", "%"))).build().evaluate()));
        placeholder.register("statistic_hours_played", (player, s) -> String.valueOf(player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20 / 60));
        placeholder.register("statistic_time_played", (player, s) -> TimerBuilder.getStringTime(player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20));
        placeholder.register("global_placeholders_", (player, args) -> {
            Object object = plugin.getGlobalPlaceholders().get(args);
            return object == null ? Message.GLOBAL_PLACEHOLDER_NOT_FOUND.getMessage() : String.valueOf(object);
        });
    }
}

