/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement;

import fr.maxlego08.menu.api.players.Data;
import fr.maxlego08.menu.api.players.DataManager;
import fr.maxlego08.menu.api.players.PlayerData;
import fr.maxlego08.menu.api.requirement.data.ActionPlayerData;
import fr.maxlego08.menu.api.requirement.data.ActionPlayerDataType;
import fr.maxlego08.menu.api.storage.StorageManager;
import fr.maxlego08.menu.hooks.exp4j.ExpressionBuilder;
import fr.maxlego08.menu.players.ZData;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ZActionPlayerData
extends ZUtils
implements ActionPlayerData {
    private final StorageManager storageManager;
    private final String key;
    private final ActionPlayerDataType type;
    private final Object value;
    private final long seconds;
    private final boolean enableMathExpression;

    public ZActionPlayerData(StorageManager storageManager, String key, ActionPlayerDataType type, Object value, long seconds, boolean enableMathExpression) {
        this.storageManager = storageManager;
        this.key = key;
        this.type = type;
        this.value = value;
        this.seconds = seconds;
        this.enableMathExpression = enableMathExpression;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ActionPlayerDataType getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long getSeconds() {
        return this.seconds;
    }

    @Override
    public Data toData(OfflinePlayer player) {
        long expiredAt = this.seconds == 0L ? 0L : System.currentTimeMillis() + 1000L * this.seconds;
        String result = this.papi(this.value.toString(), player, false);
        String dataValue = this.enableMathExpression ? String.valueOf((int)new ExpressionBuilder(result).build().evaluate()) : result;
        return new ZData(this.papi(this.key, player, false), dataValue, expiredAt);
    }

    public String toString() {
        return "ZActionPlayerData [key=" + this.key + ", type=" + String.valueOf((Object)this.type) + ", value=" + String.valueOf(this.value) + ", seconds=" + this.seconds + "]";
    }

    @Override
    public void execute(Player player, DataManager dataManager) {
        if (this.type == ActionPlayerDataType.REMOVE) {
            Optional<PlayerData> optional = dataManager.getPlayer(player.getUniqueId());
            optional.ifPresent(data -> data.removeData(this.papi(this.key, (OfflinePlayer)player, false)));
        } else if (this.type == ActionPlayerDataType.ADD) {
            Optional<Data> optional = dataManager.getData(player.getUniqueId(), this.papi(this.key, (OfflinePlayer)player, false));
            if (optional.isPresent()) {
                Data data2 = optional.get();
                String result = this.papi(this.value.toString(), (OfflinePlayer)player, false);
                data2.add(this.enableMathExpression ? (int)new ExpressionBuilder(result).build().evaluate() : Integer.parseInt(result));
                this.storageManager.upsertData(player.getUniqueId(), data2);
            } else {
                dataManager.addData(player.getUniqueId(), this.toData((OfflinePlayer)player));
            }
        } else if (this.type == ActionPlayerDataType.SUBTRACT) {
            Optional<Data> optional = dataManager.getData(player.getUniqueId(), this.papi(this.key, (OfflinePlayer)player, false));
            if (optional.isPresent()) {
                Data data3 = optional.get();
                String result = this.papi(this.value.toString(), (OfflinePlayer)player, false);
                data3.remove(this.enableMathExpression ? (int)new ExpressionBuilder(result).build().evaluate() : Integer.parseInt(result));
                this.storageManager.upsertData(player.getUniqueId(), data3);
            } else {
                Data data4 = this.toData((OfflinePlayer)player);
                data4.negate();
                dataManager.addData(player.getUniqueId(), data4);
            }
        } else if (this.type == ActionPlayerDataType.SET) {
            dataManager.addData(player.getUniqueId(), this.toData((OfflinePlayer)player));
        }
    }
}

