/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement.actions;

import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.requirement.actions.ActionHelper;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BroadcastAction
extends ActionHelper {
    private final List<String> messages;
    private final boolean miniMessage;
    private final List<Permissible> requirements;

    public BroadcastAction(List<String> messages, boolean miniMessage, List<Permissible> requirements) {
        this.messages = messages;
        this.miniMessage = miniMessage;
        this.requirements = requirements;
    }

    @Override
    public void execute(Player sender, Button button, InventoryEngine inventory, Placeholders placeholders) {
        Bukkit.getOnlinePlayers().forEach(player -> {
            boolean allowed = true;
            if (!this.requirements.isEmpty()) {
                for (Permissible requirement : this.requirements) {
                    if (requirement.hasPermission((Player)player, button, inventory, placeholders)) continue;
                    allowed = false;
                    break;
                }
            }
            if (allowed) {
                this.papi(placeholders.parse(this.messages), (Player)player).forEach(message -> {
                    message = message.replace("%sender%", sender.getName());
                    message = message.replace("%receiver%", player.getName());
                    if (this.miniMessage) {
                        inventory.getPlugin().getMetaUpdater().sendMessage((CommandSender)player, (String)message);
                    } else {
                        player.sendMessage(message);
                    }
                });
            }
        });
    }
}

