/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement.checker;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.checker.InventoryLoadRequirement;
import fr.maxlego08.menu.api.checker.InventoryRequirementType;
import fr.maxlego08.menu.api.pattern.PatternManager;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class ConfigurationChecker
extends ZUtils {
    protected final ZMenuPlugin plugin;
    protected final InventoryManager inventoryManager;
    protected final ButtonManager buttonManager;
    protected final PatternManager patternManager;

    public ConfigurationChecker(ZMenuPlugin plugin) {
        this.plugin = plugin;
        this.buttonManager = plugin.getButtonManager();
        this.inventoryManager = plugin.getInventoryManager();
        this.patternManager = plugin.getPatternManager();
    }

    protected void checkRequirement(YamlConfiguration configuration, String path, InventoryLoadRequirement inventoryLoadRequirement) {
        List requirements = configuration.getList(path + "requirements", configuration.getList(path + "requirement", new ArrayList()));
        this.buttonManager.getEmptyPermissible(requirements).forEach(name -> inventoryLoadRequirement.addRequirement(InventoryRequirementType.PERMISSIBLE, (String)name));
        this.checkAction(configuration, path + "success", inventoryLoadRequirement);
        this.checkAction(configuration, path + "deny", inventoryLoadRequirement);
    }

    protected void checkAction(YamlConfiguration configuration, String path, InventoryLoadRequirement inventoryLoadRequirement) {
        List actions = configuration.getList(path, new ArrayList());
        this.buttonManager.getEmptyActions(actions).forEach(name -> inventoryLoadRequirement.addRequirement(InventoryRequirementType.ACTION, (String)name));
    }
}

