/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement.permissible;

import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.permissible.PermissionPermissible;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class ZPermissionPermissible
extends PermissionPermissible {
    private final String permission;
    private final boolean isReverse;

    public ZPermissionPermissible(String permission, List<Action> denyActions, List<Action> successActions) {
        super(denyActions, successActions);
        String[] processedPermission = this.processPermission(permission);
        this.permission = processedPermission[0];
        this.isReverse = Boolean.parseBoolean(processedPermission[1]);
    }

    public ZPermissionPermissible(String permission) {
        super(new ArrayList<Action>(), new ArrayList<Action>());
        String[] processedPermission = this.processPermission(permission);
        this.permission = processedPermission[0];
        this.isReverse = Boolean.parseBoolean(processedPermission[1]);
    }

    private String[] processPermission(String permission) {
        boolean isReverse;
        boolean bl = isReverse = permission != null && permission.startsWith("!");
        if (isReverse) {
            permission = permission.substring(1);
        }
        return new String[]{permission, String.valueOf(isReverse)};
    }

    @Override
    public boolean hasPermission(Player player, Button button, InventoryEngine inventory, Placeholders placeholders) {
        return this.isReverse != player.hasPermission(inventory.getPlugin().parse(player, placeholders.parse(this.permission)));
    }

    @Override
    public boolean isValid() {
        if (this.permission == null) {
            Logger.info("Permission is null !", Logger.LogType.WARNING);
        }
        return this.permission != null;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public boolean isReverse() {
        return this.isReverse;
    }
}

