/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.save;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.enums.MessageType;
import fr.maxlego08.menu.api.utils.Message;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageLoader {
    private final List<Message> loadedMessages = new ArrayList<Message>();
    private final ZMenuPlugin plugin;

    public MessageLoader(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    public void save() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        for (Message message : Message.values()) {
            String path = message.name().toLowerCase().replace("_", "-");
            if (configuration.contains(path)) continue;
            if (message.getType() != MessageType.TCHAT) {
                configuration.set(path + ".type", (Object)message.getType().name());
                configuration.set(path + ".message", (Object)message.getMessage());
            }
            if (!message.getType().equals((Object)MessageType.TCHAT) && !message.getType().equals((Object)MessageType.ACTION) && !message.getType().equals((Object)MessageType.CENTER)) continue;
            if (message.isMessage()) {
                if (message.getType() != MessageType.TCHAT) {
                    configuration.set(path + ".messages", message.getMessages());
                    continue;
                }
                configuration.set(path, message.getMessages());
                continue;
            }
            if (message.getType() != MessageType.TCHAT) {
                configuration.set(path + ".message", (Object)message.getMessage());
                continue;
            }
            configuration.set(path, (Object)message.getMessage());
        }
        try {
            configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.loadMessages(configuration);
    }

    public void load() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            this.save();
            return;
        }
        this.loadMessages(YamlConfiguration.loadConfiguration((File)file));
    }

    private void loadMessages(YamlConfiguration configuration) {
        this.loadedMessages.clear();
        for (String key : configuration.getKeys(false)) {
            this.loadMessage(configuration, key);
        }
        boolean canSave = false;
        for (Message message : Message.values()) {
            if (this.loadedMessages.contains(message)) continue;
            canSave = true;
            break;
        }
        if (canSave) {
            this.save();
        }
    }

    private void loadMessage(YamlConfiguration configuration, String key) {
        try {
            Message message = Message.valueOf(key.toUpperCase().replace("-", "_"));
            if (configuration.contains(key + ".type")) {
                MessageType messageType = MessageType.valueOf(configuration.getString(key + ".type", "TCHAT").toUpperCase());
                message.setType(messageType);
                switch (messageType) {
                    case ACTION: 
                    case TCHAT_AND_ACTION: {
                        message.setMessage(configuration.getString(key + ".message"));
                        break;
                    }
                    case CENTER: 
                    case TCHAT: 
                    case WITHOUT_PREFIX: {
                        List messages = configuration.getStringList(key + ".messages");
                        if (messages.isEmpty()) {
                            message.setMessage(configuration.getString(key + ".message"));
                            break;
                        }
                        message.setMessages(messages);
                        break;
                    }
                }
            } else {
                message.setType(MessageType.TCHAT);
                List messages = configuration.getStringList(key);
                if (messages.isEmpty()) {
                    message.setMessage(configuration.getString(key));
                } else {
                    message.setMessages(messages);
                }
            }
            this.loadedMessages.add(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

