/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.sound;

import fr.maxlego08.menu.api.sound.SoundOption;
import fr.maxlego08.menu.hooks.xseries.XSound;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ZSoundOption
implements SoundOption {
    private final XSound sound;
    private final XSound.Category category;
    private final String soundAsString;
    private final float pitch;
    private final float volume;
    private final boolean isCustom;

    public ZSoundOption(XSound sound, String categoryName, String soundAsString, float pitch, float volume, boolean isCustom) {
        XSound.Category localCategory;
        this.sound = sound;
        try {
            localCategory = XSound.Category.valueOf(categoryName.toUpperCase());
        }
        catch (Exception e) {
            localCategory = XSound.Category.MASTER;
        }
        this.category = localCategory;
        this.soundAsString = soundAsString;
        this.pitch = pitch;
        this.volume = volume;
        this.isCustom = isCustom;
    }

    @Override
    public XSound getSound() {
        return this.sound;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom;
    }

    @Override
    public void play(Entity entity) {
        if (this.soundAsString != null && this.isCustom()) {
            Location location = entity.getLocation();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                SoundCategory soundCategory = SoundCategory.valueOf((String)this.category.name());
                player.playSound(location, this.soundAsString, soundCategory, this.volume, this.pitch);
            } else {
                location.getWorld().playSound(location, this.soundAsString, this.volume, this.pitch);
            }
        }
        if (this.sound != null) {
            if (entity instanceof Player) {
                this.sound.record().withVolume(this.volume).withPitch(this.pitch).inCategory(this.category).soundPlayer().forPlayers((Player)entity).play();
            } else {
                this.sound.play(entity, this.volume, this.pitch);
            }
        }
    }
}

