/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.website;

import com.google.gson.JsonObject;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.loader.NoneLoader;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.api.website.WebsiteManager;
import fr.maxlego08.menu.placeholder.LocalPlaceholder;
import fr.maxlego08.menu.website.Folder;
import fr.maxlego08.menu.website.Inventory;
import fr.maxlego08.menu.website.Resource;
import fr.maxlego08.menu.website.Token;
import fr.maxlego08.menu.website.buttons.ButtonBuilderRefresh;
import fr.maxlego08.menu.website.buttons.ButtonFolderBack;
import fr.maxlego08.menu.website.buttons.ButtonFolderNext;
import fr.maxlego08.menu.website.buttons.ButtonFolderPrevious;
import fr.maxlego08.menu.website.buttons.ButtonFolders;
import fr.maxlego08.menu.website.buttons.ButtonInventories;
import fr.maxlego08.menu.website.buttons.ButtonInventoryNext;
import fr.maxlego08.menu.website.buttons.ButtonInventoryPrevious;
import fr.maxlego08.menu.website.buttons.ButtonMarketplace;
import fr.maxlego08.menu.website.request.HttpRequest;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ZWebsiteManager
extends ZUtils
implements WebsiteManager {
    private final String API_URL = "https://minecraft-inventory-builder.com/api/v1/";
    private final ZMenuPlugin plugin;
    private final List<Folder> folders = new ArrayList<Folder>();
    private boolean isLogin = false;
    private boolean isDownloadResource = false;
    private long lastResourceUpdate = 0L;
    private List<Resource> resources = new ArrayList<Resource>();
    private int folderPage = 1;
    private int inventoryPage = 1;
    private int currentFolderId = -1;
    private int baseFolderId = 1;

    public ZWebsiteManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void login(CommandSender sender, String token) {
        if (token == null) {
            this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_ERROR_TOKEN, new Object[0]);
            return;
        }
        if (Token.token != null) {
            this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_ERROR_ALREADY, new Object[0]);
            return;
        }
        String[] parts = token.split("\\|");
        if (parts.length != 2) {
            this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_ERROR_TOKEN, new Object[0]);
            return;
        }
        String code = parts[1];
        if (code.length() < 40) {
            this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_ERROR_TOKEN, new Object[0]);
            return;
        }
        if (this.isLogin) {
            this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_PROCESS, new Object[0]);
            return;
        }
        this.isLogin = true;
        this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_PROCESS, new Object[0]);
        JsonObject data = new JsonObject();
        HttpRequest request = new HttpRequest(this.API_URL + "auth/test", data);
        request.setBearer(token);
        request.submit(this.plugin, map -> {
            this.isLogin = false;
            boolean status = map.getOrDefault("status", false);
            if (status) {
                Token.token = token;
                Token.getInstance().save(this.plugin.getPersist());
                this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_SUCCESS, new Object[0]);
            } else {
                this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_LOGIN_ERROR_INFO, new Object[0]);
            }
        });
    }

    @Override
    public void disconnect(CommandSender sender) {
        if (Token.token == null) {
            this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_DISCONNECT_ERROR, new Object[0]);
            return;
        }
        Token.token = null;
        Token.getInstance().save(this.plugin.getPersist());
        this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_DISCONNECT_SUCCESS, new Object[0]);
    }

    @Override
    public void openMarketplace(Player player) {
        if (Token.token == null) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_NOT_CONNECT, new Object[0]);
            return;
        }
        if (this.lastResourceUpdate > System.currentTimeMillis()) {
            this.openMarketplaceInventory(player);
        } else {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_MARKETPLACE_WAIT, new Object[0]);
            if (this.isDownloadResource) {
                return;
            }
            this.isDownloadResource = true;
            JsonObject data = new JsonObject();
            HttpRequest request = new HttpRequest(this.API_URL + "resources", data);
            request.setBearer(Token.token);
            request.setMethod("GET");
            request.submit(this.plugin, map -> {
                this.isDownloadResource = false;
                this.lastResourceUpdate = System.currentTimeMillis() + 900000L;
                List maps = (List)map.get("resources");
                ArrayList<Resource> loadedResources = new ArrayList<Resource>(maps.size());
                for (Map resourceMap : maps) {
                    loadedResources.add(new Resource(resourceMap));
                }
                this.resources = loadedResources;
                this.plugin.getScheduler().runAtEntity((Entity)player, w -> this.openMarketplaceInventory(player));
            });
        }
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void registerPlaceholders() {
        LocalPlaceholder localPlaceholder = LocalPlaceholder.getInstance();
        localPlaceholder.register("marketplace_resources", (a, b) -> String.valueOf(this.resources.size()));
    }

    public void openMarketplaceInventory(Player player) {
        this.plugin.getInventoryManager().openInventory(player, this.plugin, "marketplace");
    }

    public void openInventoriesInventory(Player player, int inventorypage, int folderPage, int currentFolderId) {
        this.inventoryPage = inventorypage;
        this.folderPage = folderPage;
        this.currentFolderId = currentFolderId;
        this.plugin.getInventoryManager().openInventory(player, this.plugin, "inventories");
    }

    public void loadButtons(ButtonManager buttonManager) {
        buttonManager.register(new NoneLoader(this.plugin, ButtonMarketplace.class, "zmenu_marketplace_resources"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonFolders.class, "zmenu_builder_folders"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonFolderNext.class, "zmenu_builder_folder_next"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonFolderPrevious.class, "zmenu_builder_folder_previous"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonFolderBack.class, "zmenu_builder_folder_back"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonBuilderRefresh.class, "zmenu_builder_refresh"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonInventories.class, "zmenu_builder_inventories"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonInventoryPrevious.class, "zmenu_builder_inventory_previous"));
        buttonManager.register(new NoneLoader(this.plugin, ButtonInventoryNext.class, "zmenu_builder_inventory_next"));
    }

    private void loadFiles() {
        ArrayList<String> files = new ArrayList<String>();
        files.add("website/inventories.yml");
        files.forEach(filePath -> {
            if (NmsVersion.nmsVersion.isNewMaterial()) {
                if (!new File(this.plugin.getDataFolder(), (String)filePath).exists()) {
                    this.plugin.saveResource(filePath.replace("website/", "website/1_13/"), (String)filePath, true);
                }
            } else {
                this.plugin.saveResource((String)filePath, !Config.enableDebug);
            }
        });
    }

    public void loadInventories(InventoryManager inventoryManager) {
        this.loadFiles();
        try {
            inventoryManager.loadInventory((Plugin)this.plugin, "website/inventories.yml");
        }
        catch (InventoryException exception) {
            exception.printStackTrace();
        }
    }

    public void fetchInventories(Player player) {
        if (Token.token == null) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_NOT_CONNECT, new Object[0]);
            return;
        }
        if (!this.folders.isEmpty()) {
            this.openInventoriesInventory(player, 1, 1, this.baseFolderId);
            return;
        }
        this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_MARKETPLACE_WAIT, new Object[0]);
        JsonObject data = new JsonObject();
        HttpRequest request = new HttpRequest(this.API_URL + "inventories", data);
        request.setBearer(Token.token);
        request.setMethod("GET");
        request.submit(this.plugin, map -> {
            boolean status = map.getOrDefault("status", false);
            if (status) {
                List folderMaps = (List)map.get("folders");
                this.folders.clear();
                for (Map folderMap : folderMaps) {
                    Folder folder = Folder.fromMap(folderMap);
                    this.folders.add(folder);
                }
                int baseId = -1;
                for (Folder folder : this.folders) {
                    if (folder.parentId() != -1) continue;
                    baseId = folder.id();
                    break;
                }
                this.baseFolderId = baseId;
                this.plugin.getScheduler().runAtEntity((Entity)player, w -> this.openInventoriesInventory(player, 1, 1, this.baseFolderId));
            } else {
                this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_MARKETPLACE_ERROR, new Object[0]);
            }
        });
    }

    public int getFolderPage() {
        return this.folderPage;
    }

    public void setFolderPage(int folderPage) {
        this.folderPage = folderPage;
    }

    public int getInventoryPage() {
        return this.inventoryPage;
    }

    public void setInventoryPage(int inventoryPage) {
        this.inventoryPage = inventoryPage;
    }

    public Optional<Folder> getCurrentFolder() {
        for (Folder folder : this.folders) {
            if (folder.id() != this.currentFolderId) continue;
            return Optional.of(folder);
        }
        return Optional.empty();
    }

    public Optional<Folder> getFolder(int id) {
        for (Folder folder : this.folders) {
            if (folder.id() != id) continue;
            return Optional.of(folder);
        }
        return Optional.empty();
    }

    public List<Folder> getFolders(Folder folder) {
        ArrayList<Folder> children = new ArrayList<Folder>();
        for (Folder current : this.folders) {
            if (current.parentId().intValue() != folder.id()) continue;
            children.add(current);
        }
        return children;
    }

    public void loadPlaceholders() {
        LocalPlaceholder placeholder = LocalPlaceholder.getInstance();
        placeholder.register("folder_name", (player, args) -> {
            Optional<Folder> optional = this.getCurrentFolder();
            return optional.isPresent() ? optional.get().name() : "Not found";
        });
    }

    private String getFolderPath(Folder folder, String path) {
        if (folder.parentId() == -1) {
            return path;
        }
        Optional<Folder> optional = this.getFolder(folder.parentId());
        if (optional.isPresent()) {
            Folder parrentFolder = optional.get();
            return this.getFolderPath(parrentFolder, folder.name() + "/" + path);
        }
        return folder.name() + "/" + path;
    }

    private File getFolderPath(Inventory inventory) {
        Optional<Folder> optional = this.getFolder(inventory.folderId());
        return optional.map(folder -> new File(this.plugin.getDataFolder(), "inventories/" + this.getFolderPath((Folder)folder, ""))).orElseGet(() -> new File(this.plugin.getDataFolder(), "inventories"));
    }

    public void downloadInventory(Player player, Inventory inventory, boolean forceDownload) {
        File folder = this.getFolderPath(inventory);
        File file = new File(folder, inventory.fileName() + ".yml");
        if (file.exists() && !forceDownload) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_INVENTORY_EXIST, new Object[0]);
            return;
        }
        player.closeInventory();
        this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.WEBSITE_INVENTORY_WAIT, "%name%", inventory.fileName());
        HttpRequest request = new HttpRequest(this.API_URL + String.format("inventory/%s/download", inventory.id()), new JsonObject());
        request.setBearer(Token.token);
        request.setMethod("GET");
        folder.mkdirs();
        request.submitForFileDownload(this.plugin, file, isSuccess -> this.message((MenuPlugin)this.plugin, (CommandSender)player, isSuccess != false ? Message.WEBSITE_INVENTORY_SUCCESS : Message.WEBSITE_INVENTORY_ERROR, "%name%", inventory.fileName()));
    }

    public void refreshInventories(Player player) {
        this.folders.clear();
        this.fetchInventories(player);
    }

    private String getFileNameFromUrl(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException exception) {
            exception.printStackTrace();
            return null;
        }
        String path = uri.getPath();
        String[] segments = path.split("/");
        if (segments.length > 0) {
            return segments[segments.length - 1];
        }
        return null;
    }

    @Override
    public void downloadFromUrl(CommandSender sender, String baseUrl, boolean force) {
        this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_DOWNLOAD_START, new Object[0]);
        this.plugin.getScheduler().runAsync(w -> {
            try {
                File file;
                String finalUrl = this.followRedirection(baseUrl);
                URL url = new URL(finalUrl);
                HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                String fileName = this.getFileNameFromContentDisposition(httpURLConnection);
                if (fileName == null) {
                    this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_DOWNLOAD_ERROR_NAME, new Object[0]);
                    return;
                }
                if (!this.isYmlFile(httpURLConnection) && !fileName.endsWith(".yml")) {
                    this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_DOWNLOAD_ERROR_TYPE, new Object[0]);
                    return;
                }
                File folder = new File(this.plugin.getDataFolder(), "inventories/downloads");
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if ((file = new File(folder, fileName)).exists() && !force) {
                    this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_INVENTORY_EXIST, new Object[0]);
                    return;
                }
                HttpRequest request = new HttpRequest(finalUrl, new JsonObject());
                request.setMethod("GET");
                request.submitForFileDownload(this.plugin, file, isSuccess -> this.message((MenuPlugin)this.plugin, sender, isSuccess != false ? Message.WEBSITE_INVENTORY_SUCCESS : Message.WEBSITE_INVENTORY_ERROR, "%name%", fileName));
            }
            catch (IOException exception) {
                exception.printStackTrace();
                this.message((MenuPlugin)this.plugin, sender, Message.WEBSITE_DOWNLOAD_ERROR_CONSOLE, new Object[0]);
            }
        });
    }

    private String followRedirection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        int status = conn.getResponseCode();
        if (status == 302 || status == 301 || status == 303) {
            return conn.getHeaderField("Location");
        }
        return urlString;
    }

    private boolean isYmlFile(HttpURLConnection connection) throws IOException {
        String contentType = connection.getContentType();
        return contentType.contains("text/yaml") || contentType.contains("application/x-yaml");
    }

    private String getFileNameFromContentDisposition(HttpURLConnection conn) {
        int index;
        String contentDisposition = conn.getHeaderField("Content-Disposition");
        if (contentDisposition != null && (index = contentDisposition.indexOf("filename=")) > 0) {
            return contentDisposition.substring(index + 9).replaceAll("\"", "");
        }
        return this.generateRandomString(16);
    }
}

