/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.exceptions.ListenerNullException;
import fr.maxlego08.menu.api.players.Data;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.command.VCommandManager;
import fr.maxlego08.menu.inventory.VInventory;
import fr.maxlego08.menu.inventory.VInventoryManager;
import fr.maxlego08.menu.listener.ListenerAdapter;
import fr.maxlego08.menu.placeholder.LocalPlaceholder;
import fr.maxlego08.menu.placeholder.Placeholder;
import fr.maxlego08.menu.zcore.enums.EnumInventory;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.gson.DataAdapter;
import fr.maxlego08.menu.zcore.utils.gson.LocationAdapter;
import fr.maxlego08.menu.zcore.utils.gson.PotionEffectAdapter;
import fr.maxlego08.menu.zcore.utils.plugins.Plugins;
import fr.maxlego08.menu.zcore.utils.storage.Persist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public abstract class ZPlugin
extends JavaPlugin {
    private final Logger log = new Logger(this.getDescription().getFullName());
    private final List<ListenerAdapter> listenerAdapters = new ArrayList<ListenerAdapter>();
    protected VCommandManager zCommandManager;
    protected VInventoryManager vinventoryManager;
    private long enableTime;
    private Gson gson;
    private Persist persist;

    protected void preEnable() {
        LocalPlaceholder.getInstance().setPlugin((ZMenuPlugin)this);
        this.enableTime = System.currentTimeMillis();
        this.log.log("=== ENABLE START ===");
        this.log.log("Plugin Version V<&>c" + this.getDescription().getVersion(), Logger.LogType.INFO);
        this.getDataFolder().mkdirs();
        this.gson = this.getGsonBuilder().create();
        this.persist = new Persist(this);
        Placeholder.Placeholders.getPlaceholder();
    }

    protected void postEnable() {
        if (this.zCommandManager != null) {
            this.zCommandManager.validCommands();
        }
        this.log.log("=== ENABLE DONE <&>7(<&>6" + Math.abs(this.enableTime - System.currentTimeMillis()) + "ms<&>7) <&>e===");
    }

    protected void preDisable() {
        this.enableTime = System.currentTimeMillis();
        this.log.log("=== DISABLE START ===");
    }

    protected void postDisable() {
        this.log.log("=== DISABLE DONE <&>7(<&>6" + Math.abs(this.enableTime - System.currentTimeMillis()) + "ms<&>7) <&>e===");
    }

    public GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().excludeFieldsWithModifiers(new int[]{128, 64}).registerTypeAdapter(PotionEffect.class, (Object)new PotionEffectAdapter(this)).registerTypeAdapter(Data.class, (Object)new DataAdapter(this)).registerTypeAdapter(Location.class, (Object)new LocationAdapter(this));
    }

    public void addListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void addSimpleListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void addListener(ListenerAdapter adapter) {
        if (adapter == null) {
            throw new ListenerNullException("Warning, your listener is null");
        }
        this.listenerAdapters.add(adapter);
    }

    public Logger getLog() {
        return this.log;
    }

    public List<ListenerAdapter> getListenerAdapters() {
        return this.listenerAdapters;
    }

    public VCommandManager getVCommandManager() {
        return this.zCommandManager;
    }

    public VInventoryManager getVInventoryManager() {
        return this.vinventoryManager;
    }

    public boolean isEnable(Plugins pluginName) {
        Plugin plugin = this.getPlugin(pluginName);
        return plugin != null && plugin.isEnabled();
    }

    public boolean isActive(Plugins pluginName) {
        Plugin plugin = this.getPlugin(pluginName);
        return plugin != null;
    }

    protected Plugin getPlugin(Plugins plugin) {
        return Bukkit.getPluginManager().getPlugin(plugin.getName());
    }

    protected void registerCommand(String command, VCommand vCommand, String ... aliases) {
        this.zCommandManager.registerCommand((Plugin)this, command, vCommand, Arrays.asList(aliases));
    }

    protected void registerInventory(EnumInventory inventory, VInventory vInventory) {
        this.vinventoryManager.registerInventory(inventory, vInventory);
    }

    public void saveResource(String resourcePath, String toPath, boolean replace) {
        block8: {
            if (resourcePath != null && !resourcePath.isEmpty()) {
                InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
                if (in == null) {
                    throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + String.valueOf(this.getFile()));
                }
                File outFile = new File(this.getDataFolder(), toPath);
                int lastIndex = toPath.lastIndexOf(47);
                File outDir = new File(this.getDataFolder(), toPath.substring(0, Math.max(lastIndex, 0)));
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                try {
                    int len;
                    if (outFile.exists() && !replace) {
                        this.getLogger().log(Level.WARNING, "Could not save " + outFile.getName() + " to " + String.valueOf(outFile) + " because " + outFile.getName() + " already exists.");
                        break block8;
                    }
                    OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    in.close();
                }
                catch (IOException var10) {
                    this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + String.valueOf(outFile), var10);
                }
            } else {
                throw new IllegalArgumentException("ResourcePath cannot be null or empty");
            }
        }
    }

    public Persist getPersist() {
        return this.persist;
    }

    public Gson getGson() {
        return this.gson;
    }
}

