/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.IMessage;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.zcore.utils.DefaultFontInfo;
import fr.maxlego08.menu.zcore.utils.LocationUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.lang.reflect.Constructor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public abstract class MessageUtils
extends LocationUtils {
    protected void messageWO(MenuPlugin plugin, CommandSender sender, IMessage message, Object ... args) {
        plugin.getMetaUpdater().sendMessage(sender, this.getMessage(message, args));
    }

    protected void messageWO(MenuPlugin plugin, CommandSender sender, String message, Object ... args) {
        String result = this.getMessage(message, args);
        plugin.getMetaUpdater().sendMessage(sender, sender instanceof Player ? this.papi(result, (OfflinePlayer)((Player)sender), false) : result);
    }

    protected void message(MenuPlugin plugin, CommandSender sender, String message, Object ... args) {
        plugin.getMetaUpdater().sendMessage(sender, Message.PREFIX.msg() + this.getMessage(message, args));
    }

    protected void message(MenuPlugin plugin, CommandSender sender, IMessage message, Object ... args) {
        if (sender instanceof ConsoleCommandSender) {
            if (!message.getMessages().isEmpty()) {
                message.getMessages().forEach(msg -> plugin.getMetaUpdater().sendMessage(sender, Message.PREFIX.msg() + this.getMessage((String)msg, args)));
            } else {
                plugin.getMetaUpdater().sendMessage(sender, Message.PREFIX.msg() + this.getMessage(message, args));
            }
        } else {
            Player player = (Player)sender;
            switch (message.getType()) {
                case CENTER: {
                    if (!message.getMessages().isEmpty()) {
                        message.getMessages().forEach(msg -> plugin.getMetaUpdater().sendMessage(sender, this.getCenteredMessage(this.getMessage((String)msg, args))));
                        break;
                    }
                    plugin.getMetaUpdater().sendMessage(sender, this.getCenteredMessage(this.getMessage(message, args)));
                    break;
                }
                case ACTION: {
                    plugin.getMetaUpdater().sendAction(player, this.getMessage(message, args));
                    break;
                }
                case TCHAT: {
                    if (!message.getMessages().isEmpty()) {
                        message.getMessages().forEach(msg -> plugin.getMetaUpdater().sendMessage(sender, Message.PREFIX.msg() + this.getMessage((String)msg, args)));
                        break;
                    }
                    plugin.getMetaUpdater().sendMessage(sender, Message.PREFIX.msg() + this.getMessage(message, args));
                    break;
                }
            }
        }
    }

    protected String getMessage(IMessage message, Object ... args) {
        return this.getMessage(message.getMessage(), args);
    }

    protected String getMessage(String message, Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Number of invalid arguments. Arguments must be in pairs.");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i] == null || args[i + 1] == null) {
                throw new IllegalArgumentException("Keys and replacement values must not be null.");
            }
            message = message.replace(args[i].toString(), args[i + 1].toString());
        }
        return message;
    }

    protected final Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3] + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void title(Player player, String title, String subtitle, int fadeInTime, int showTime, int fadeOutTime) {
        if (NmsVersion.nmsVersion.isNewMaterial()) {
            player.sendTitle(title, subtitle, fadeInTime, showTime, fadeOutTime);
            return;
        }
        try {
            Object chatTitle = this.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\": \"" + title + "\"}");
            Constructor<?> titleConstructor = this.getNMSClass("PacketPlayOutTitle").getConstructor(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0], this.getNMSClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object packet = titleConstructor.newInstance(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("TITLE").get(null), chatTitle, fadeInTime, showTime, fadeOutTime);
            Object chatsTitle = this.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\": \"" + subtitle + "\"}");
            Constructor<?> timingTitleConstructor = this.getNMSClass("PacketPlayOutTitle").getConstructor(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0], this.getNMSClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object timingPacket = timingTitleConstructor.newInstance(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("SUBTITLE").get(null), chatsTitle, fadeInTime, showTime, fadeOutTime);
            this.sendPacket(player, packet);
            this.sendPacket(player, timingPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
            playerConnection.getClass().getMethod("sendPacket", this.getNMSClass("Packet")).invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getCenteredMessage(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int CENTER_PX = 154;
        int toCompensate = CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return String.valueOf(sb) + message;
    }
}

