/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils;

import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.placeholder.Placeholder;
import fr.maxlego08.menu.zcore.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;

public class PapiUtils
extends TranslationHelper {
    private static volatile Placeholder placeholder;
    private final transient ConcurrentHashMap<String, CacheEntry> cache = new ConcurrentHashMap();

    private Placeholder use() {
        if (placeholder == null) {
            placeholder = Placeholder.Placeholders.getPlaceholder();
        }
        return placeholder;
    }

    public Object papi(Object placeHolder, OfflinePlayer player, boolean useCache) {
        return placeHolder instanceof String ? this.papi((String)placeHolder, player, useCache) : placeHolder;
    }

    public String papi(String placeHolder, OfflinePlayer player, boolean useCache) {
        if (placeHolder == null) {
            return null;
        }
        if (player == null) {
            return placeHolder;
        }
        if (!placeHolder.contains("%")) {
            return placeHolder;
        }
        String cacheKey = placeHolder + ";" + String.valueOf(player.getUniqueId());
        CacheEntry cachedResult = this.cache.get(cacheKey);
        if (Config.enableCachePlaceholderAPI && cachedResult != null && cachedResult.isValid() && useCache) {
            return cachedResult.value;
        }
        String result = this.use().setPlaceholders(player, placeHolder).replace("%player%", player.getName());
        if (Config.enableCachePlaceholderAPI) {
            this.cache.put(cacheKey, new CacheEntry(result, System.currentTimeMillis()));
        }
        return result;
    }

    public List<String> papi(List<String> placeHolders, OfflinePlayer player, boolean useCache) {
        if (player == null) {
            return placeHolders;
        }
        ArrayList<String> parsed = new ArrayList<String>(placeHolders.size());
        for (String placeHolder : placeHolders) {
            parsed.add(this.papi(placeHolder, player, useCache));
        }
        return parsed;
    }

    private record CacheEntry(String value, long timeStamp) {
        public boolean isValid() {
            return System.currentTimeMillis() - this.timeStamp < Config.cachePlaceholderAPI;
        }
    }
}

