/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.OpenLink;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ZOpenLink
extends ZUtils
implements OpenLink {
    private final MenuPlugin plugin;
    private final ClickEvent.Action action;
    private final String message;
    private final String link;
    private final String replace;
    private final List<String> hover;

    public ZOpenLink(MenuPlugin plugin, ClickEvent.Action action, String message, String link, String replace, List<String> hover) {
        this.plugin = plugin;
        this.action = action;
        this.message = message;
        this.link = link;
        this.replace = replace;
        this.hover = hover;
    }

    public ZOpenLink() {
        this(null, null, null, null, null, null);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public String getReplace() {
        return this.replace;
    }

    @Override
    public List<String> getHover() {
        return this.hover;
    }

    @Override
    public ClickEvent.Action getAction() {
        return this.action;
    }

    @Override
    public void send(Player player, List<String> messages) {
        if (this.isValid()) {
            messages.forEach(message -> {
                String finalMessage = this.papi((String)message, (OfflinePlayer)player, true);
                if (finalMessage.contains(this.replace)) {
                    String[] splitMessages = finalMessage.split(this.replace);
                    TextComponent component = this.buildTextComponent(splitMessages[0]);
                    TextComponent clickComponent = this.buildTextComponent(this.color(this.message));
                    this.setClickAction(clickComponent, ClickEvent.Action.OPEN_URL, this.link);
                    this.setHoverMessage(clickComponent, this.color(this.hover));
                    component.addExtra((BaseComponent)clickComponent);
                    if (splitMessages.length == 2) {
                        component.addExtra((BaseComponent)this.buildTextComponent(splitMessages[1]));
                    }
                    player.spigot().sendMessage((BaseComponent)component);
                } else {
                    this.plugin.getMetaUpdater().sendMessage((CommandSender)player, finalMessage);
                }
            });
        } else {
            messages.forEach(message -> this.plugin.getMetaUpdater().sendMessage((CommandSender)player, this.papi((String)message, (OfflinePlayer)player, true)));
        }
    }

    @Override
    public boolean isValid() {
        return this.action != null && this.replace != null && this.hover != null && this.link != null && this.message != null && this.plugin != null;
    }
}

