/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.api.utils.SimpleCache;
import fr.maxlego08.menu.zcore.SkinUrlDecoder;
import fr.maxlego08.menu.zcore.enums.EnumInventory;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.MessageUtils;
import fr.maxlego08.menu.zcore.utils.RandomString;
import fr.maxlego08.menu.zcore.utils.builder.CooldownBuilder;
import fr.maxlego08.menu.zcore.utils.builder.TimerBuilder;
import fr.maxlego08.menu.zcore.utils.nms.NMSUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import fr.maxlego08.menu.zcore.utils.players.ActionBar;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public abstract class ZUtils
extends MessageUtils {
    private static final Timer TIMER = new Timer();
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");
    private static final SimpleCache<String, Object> cache = new SimpleCache();
    private static final ConcurrentHashMap<Path, CachedLines> CONFIGURATION_CACHE = new ConcurrentHashMap();
    private static Material[] byId;

    protected String findPlayerLocale(Player player) {
        if (NmsVersion.getCurrentVersion().getVersion() >= NmsVersion.V_1_13.getVersion()) {
            try {
                return player != null ? player.getLocale() : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected boolean isMinecraftName(String username) {
        String MINECRAFT_USERNAME_REGEX = "^[a-zA-Z0-9_]{3,16}$";
        Pattern pattern = Pattern.compile(MINECRAFT_USERNAME_REGEX);
        Matcher matcher = pattern.matcher(username);
        return matcher.matches();
    }

    protected int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected int getInventorySizeByMatrix(List<String> matrix) {
        return Math.min(matrix.size() * 9, 54);
    }

    protected Map<Character, List<Integer>> generateMatrix(List<String> matrix) {
        HashMap<Character, List<Integer>> charMap = new HashMap<Character, List<Integer>>();
        if (matrix == null || matrix.size() > 6) {
            Logger.info("Matrix is wrong !", Logger.LogType.ERROR);
            return new HashMap<Character, List<Integer>>();
        }
        for (String line : matrix) {
            if (line.length() <= 9) continue;
            Logger.info("Each line of the matrix must have exactly 9 characters.", Logger.LogType.ERROR);
            return new HashMap<Character, List<Integer>>();
        }
        for (int i = 0; i < matrix.size(); ++i) {
            for (int j = 0; j < Math.min(matrix.get(i).length(), 9); ++j) {
                char c = matrix.get(i).charAt(j);
                if (c == ' ') continue;
                int slot = i * 9 + j;
                charMap.computeIfAbsent(Character.valueOf(c), k -> new ArrayList()).add(slot);
            }
        }
        return charMap;
    }

    protected int getNumberBetween(int first, int second) {
        return ThreadLocalRandom.current().nextInt(first, second);
    }

    protected boolean hasInventoryFull(Player player) {
        int slot = 0;
        PlayerInventory inventory = player.getInventory();
        for (int a = 0; a != 36; ++a) {
            ItemStack itemStack = inventory.getContents()[a];
            if (itemStack != null) continue;
            ++slot;
        }
        return slot == 0;
    }

    protected void give(Player player, ItemStack item) {
        if (this.hasInventoryFull(player)) {
            player.getWorld().dropItem(player.getLocation(), item);
        } else {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }

    protected Material getMaterial(int id) {
        return byId.length > id && id >= 0 ? byId[id] : Material.AIR;
    }

    protected boolean hasDisplayName(ItemStack itemStack) {
        return itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName();
    }

    protected boolean same(ItemStack itemStack, String name) {
        return this.hasDisplayName(itemStack) && itemStack.getItemMeta().getDisplayName().equals(name);
    }

    protected boolean contains(ItemStack itemStack, String name) {
        return this.hasDisplayName(itemStack) && itemStack.getItemMeta().getDisplayName().contains(name);
    }

    protected void removeItemInHand(Player player) {
        this.removeItemInHand(player, 64);
    }

    protected void removeItemInHand(Player player, int how) {
        if (player.getItemInHand().getAmount() > how) {
            player.getItemInHand().setAmount(player.getItemInHand().getAmount() - how);
        } else {
            player.setItemInHand(new ItemStack(Material.AIR));
        }
        player.updateInventory();
    }

    protected boolean same(Location l, Location l2) {
        return l.getBlockX() == l2.getBlockX() && l.getBlockY() == l2.getBlockY() && l.getBlockZ() == l2.getBlockZ() && l.getWorld().getName().equals(l2.getWorld().getName());
    }

    protected String format(double decimal) {
        return this.format(decimal, "#.##");
    }

    protected String format(double decimal, String format) {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(decimal);
    }

    protected void removeItems(Player player, int amount, ItemStack itemStack) {
        int slot = 0;
        for (ItemStack is : player.getInventory().getContents()) {
            if (is != null && is.isSimilar(itemStack) && amount > 0) {
                int currentAmount = is.getAmount() - amount;
                amount -= is.getAmount();
                if (currentAmount <= 0) {
                    if (slot == 40) {
                        player.getInventory().setItemInOffHand(null);
                    } else {
                        player.getInventory().removeItem(new ItemStack[]{is});
                    }
                } else {
                    is.setAmount(currentAmount);
                }
            }
            ++slot;
        }
        player.updateInventory();
    }

    protected String name(String string) {
        String name = string.replace("_", " ").toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected String name(Material string) {
        String name = string.name().replace("_", " ").toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected String name(ItemStack itemStack) {
        return this.getItemName(itemStack);
    }

    protected int getMaxPage(Collection<?> items, int a) {
        return items.size() / a + 1;
    }

    protected double percent(double value, double total) {
        return value * 100.0 / total;
    }

    protected double percentNum(double total, double percent) {
        return total * (percent / 100.0);
    }

    protected void createInventory(ZMenuPlugin plugin, Player player, EnumInventory inventory) {
        this.createInventory(plugin, player, inventory, 1);
    }

    protected void createInventory(ZMenuPlugin plugin, Player player, EnumInventory inventory, int page) {
        this.createInventory(plugin, player, inventory, page, new Object(this){});
    }

    protected void createInventory(ZMenuPlugin plugin, Player player, EnumInventory inventory, int page, Object ... objects) {
        plugin.getVInventoryManager().createInventory(inventory, player, page, objects);
    }

    protected void createInventory(ZMenuPlugin plugin, Player player, int inventory, int page, Object ... objects) {
        plugin.getVInventoryManager().createInventory(inventory, player, page, objects);
    }

    protected boolean hasPermission(Permissible permissible, Permission permission) {
        return permissible.hasPermission(permission.getPermission());
    }

    protected boolean hasPermission(Permissible permissible, String permission) {
        return permissible.hasPermission(permission);
    }

    protected TimerTask scheduleFix(ZMenuPlugin plugin, long delay, BiConsumer<TimerTask, Boolean> consumer) {
        return this.scheduleFix(plugin, delay, delay, consumer);
    }

    protected TimerTask scheduleFix(final ZMenuPlugin plugin, long startAt, long delay, final BiConsumer<TimerTask, Boolean> consumer) {
        TimerTask task = new TimerTask(this){

            @Override
            public void run() {
                if (!plugin.isEnabled()) {
                    this.cancel();
                    consumer.accept(this, false);
                    return;
                }
                plugin.getScheduler().runNextTick(w -> consumer.accept(this, true));
            }
        };
        TIMER.scheduleAtFixedRate(task, startAt, delay);
        return task;
    }

    protected <T> T randomElement(List<T> element) {
        if (element.isEmpty()) {
            return null;
        }
        if (element.size() == 1) {
            return element.getFirst();
        }
        Random random = new Random();
        return element.get(random.nextInt(element.size() - 1));
    }

    protected String color(String message) {
        if (message == null) {
            return null;
        }
        if (NMSUtils.isHexColor()) {
            Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                message = message.replace(color, String.valueOf(ChatColor.of((String)color)));
                matcher = pattern.matcher(message);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String colorReverse(String message) {
        Pattern pattern = Pattern.compile("\u00a7x[a-fA-F0-9-\u00a7]{12}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String color = message.substring(matcher.start(), matcher.end());
            String colorReplace = color.replace("\u00a7x", "#");
            colorReplace = colorReplace.replace("\u00a7", "");
            message = message.replace(color, colorReplace);
            matcher = pattern.matcher(message);
        }
        return message.replace("\u00a7", "&");
    }

    protected List<String> color(List<String> messages) {
        ArrayList<String> colored = new ArrayList<String>(messages.size());
        for (String message : messages) {
            colored.add(this.color(message));
        }
        return colored;
    }

    public List<String> colorReverse(List<String> messages) {
        ArrayList<String> colored = new ArrayList<String>(messages.size());
        for (String message : messages) {
            colored.add(this.colorReverse(message));
        }
        return colored;
    }

    public ItemFlag getFlag(String flagString) {
        for (ItemFlag flag : ItemFlag.values()) {
            if (!flag.name().equalsIgnoreCase(flagString)) continue;
            return flag;
        }
        return null;
    }

    protected String generateRandomString(int length) {
        return new RandomString(length).nextString();
    }

    protected TextComponent buildTextComponent(String message) {
        return new TextComponent(message);
    }

    protected TextComponent setHoverMessage(TextComponent component, List<String> messages) {
        if (!messages.isEmpty()) {
            BaseComponent[] list = new BaseComponent[messages.size()];
            for (int a = 0; a != messages.size(); ++a) {
                list[a] = new TextComponent(messages.get(a) + (messages.size() - 1 == a ? "" : "\n"));
            }
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, list));
        }
        return component;
    }

    protected TextComponent setClickAction(TextComponent component, ClickEvent.Action action, String command) {
        component.setClickEvent(new ClickEvent(action, command));
        return component;
    }

    protected String timerFormat(Player player, String cooldown) {
        return TimerBuilder.getStringTime(CooldownBuilder.getCooldownPlayer(cooldown, player) / 1000L);
    }

    protected boolean isCooldown(Player player, String cooldown) {
        return this.isCooldown(player, cooldown, 0);
    }

    protected boolean isCooldown(Player player, String cooldown, int timer) {
        if (CooldownBuilder.isCooldown(cooldown, player)) {
            ActionBar.sendActionBar(player, String.format("\u00a7cVous devez attendre encore \u00a76%s \u00a7cavant de pouvoir faire cette action.", this.timerFormat(player, cooldown)));
            return true;
        }
        if (timer > 0) {
            CooldownBuilder.addCooldown(cooldown, player, timer);
        }
        return false;
    }

    protected String toList(Stream<String> list) {
        ArrayList<String> values = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            values.add((String)iterator.next());
        }
        return this.toList(values, "\u00a7e", "\u00a76");
    }

    protected String toList(List<String> list) {
        return this.toList(list, "\u00a7e", "\u00a76\u00a7n");
    }

    protected String toList(List<String> list, String color, String color2) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.getFirst();
        }
        String str = "";
        for (int a = 0; a != list.size(); ++a) {
            if (a == list.size() - 1) {
                str = str.concat(color + " " + Message.AND.getMessage() + " " + color2);
            } else if (a != 0) {
                str = str.concat(color + ", " + color2);
            }
            str = str.concat(list.get(a));
        }
        return str;
    }

    protected String format(long l) {
        return this.format(l, ' ');
    }

    protected String format(long l, char c) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(c);
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(l);
    }

    public ItemStack playerHead(ItemStack itemStack, OfflinePlayer player) {
        String name;
        String string = name = itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : null;
        if (NmsVersion.nmsVersion.isNewMaterial()) {
            if (itemStack.getType().equals((Object)Material.PLAYER_HEAD) && name != null && name.startsWith("HEAD")) {
                SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
                if ((name = name.replace("HEAD", "")).isEmpty()) {
                    meta.setDisplayName(null);
                } else {
                    meta.setDisplayName(name);
                }
                meta.setOwningPlayer(player);
                itemStack.setItemMeta((ItemMeta)meta);
            }
        } else if (itemStack.getType().equals((Object)this.getMaterial(397)) && itemStack.getData().getData() == 3 && name != null && name.startsWith("HEAD")) {
            SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
            if ((name = name.replace("HEAD", "")).isEmpty()) {
                meta.setDisplayName(null);
            } else {
                meta.setDisplayName(name);
            }
            meta.setOwner(player.getName());
            itemStack.setItemMeta((ItemMeta)meta);
        }
        return itemStack;
    }

    protected ItemStack playerHead() {
        return NmsVersion.nmsVersion.isNewMaterial() ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(this.getMaterial(397), 1, 3);
    }

    protected ItemStack createSkull(String url) {
        if (url == null) {
            return null;
        }
        ItemStack head = this.playerHead();
        if (url.isEmpty()) {
            return head;
        }
        if (NMSUtils.isNewHeadApi()) {
            this.applyTextureUrl(head, url);
        } else {
            this.applyTexture(head, url);
        }
        return head;
    }

    private void applyTextureUrl(ItemStack itemStack, String url) {
        Object result;
        SkullMeta headMeta = (SkullMeta)itemStack.getItemMeta();
        if (headMeta != null && (result = cache.get(url, () -> this.getProfile(url))) instanceof PlayerProfile) {
            headMeta.setOwnerProfile((PlayerProfile)result);
        }
        itemStack.setItemMeta((ItemMeta)headMeta);
    }

    private PlayerProfile getProfile(String url) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = SkinUrlDecoder.extractSkinUrl(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            exception.printStackTrace();
            return null;
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    protected void applyTexture(ItemStack itemStack, String url) {
        SkullMeta headMeta = (SkullMeta)itemStack.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), "zmenu_head");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", url));
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException error) {
            error.printStackTrace();
        }
        itemStack.setItemMeta((ItemMeta)headMeta);
    }

    protected boolean isPlayerHead(ItemStack itemStack) {
        Material material = itemStack.getType();
        if (NmsVersion.nmsVersion.isNewMaterial()) {
            return material.equals((Object)Material.PLAYER_HEAD);
        }
        return material.equals((Object)this.getMaterial(397)) && itemStack.getDurability() == 3;
    }

    protected Object getPrivateField(Object object, String field) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field objectField = field.equals("commandMap") ? clazz.getDeclaredField(field) : (field.equals("knownCommands") ? (NmsVersion.nmsVersion.isNewMaterial() ? clazz.getSuperclass().getDeclaredField(field) : clazz.getDeclaredField(field)) : null);
        objectField.setAccessible(true);
        Object result = objectField.get(object);
        objectField.setAccessible(false);
        return result;
    }

    protected void unRegisterBukkitCommand(Plugin plugin, PluginCommand command) {
        try {
            Object result = this.getPrivateField(plugin.getServer().getPluginManager(), "commandMap");
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            knownCommands.remove(command.getName());
            for (String alias : command.getAliases()) {
                knownCommands.remove(alias);
            }
            knownCommands.remove(plugin.getDescription().getName() + ":" + command.getName());
            for (String alias : command.getAliases()) {
                knownCommands.remove(plugin.getDescription().getName() + ":" + alias);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getProgressBar(int current, int max, int totalBars, char symbol, String completedColor, String notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        return Strings.repeat((String)(completedColor + symbol), (int)progressBars) + Strings.repeat((String)(notCompletedColor + symbol), (int)(totalBars - progressBars));
    }

    protected boolean inventoryHasItem(Player player) {
        ItemStack itemStack = player.getInventory().getBoots();
        if (itemStack != null) {
            return true;
        }
        itemStack = player.getInventory().getChestplate();
        if (itemStack != null) {
            return true;
        }
        itemStack = player.getInventory().getLeggings();
        if (itemStack != null) {
            return true;
        }
        itemStack = player.getInventory().getHelmet();
        if (itemStack != null) {
            return true;
        }
        for (ItemStack itemStack1 : player.getInventory().getContents()) {
            if (itemStack1 == null) continue;
            return true;
        }
        return false;
    }

    public String getFileNameWithoutExtension(File file) {
        Pattern pattern = Pattern.compile("(?<=.)\\.[^.]+$");
        return pattern.matcher(file.getName()).replaceAll("").replace(" ", "_");
    }

    protected YamlConfiguration loadAndReplaceConfiguration(File file, Map<String, Object> mapPlaceholders) {
        YamlConfiguration loadConfiguration = new YamlConfiguration();
        try {
            CachedLines cachedLines = ZUtils.getCachedLines(file);
            StringBuilder builder = new StringBuilder();
            Placeholders placeholders = new Placeholders();
            Map<String, Object> placeholdersMap = mapPlaceholders != null ? mapPlaceholders : Collections.emptyMap();
            Iterator<String> iterator = cachedLines.lines().iterator();
            while (iterator.hasNext()) {
                String originalLine;
                String line = originalLine = iterator.next();
                for (Map.Entry<String, Object> replacement : placeholdersMap.entrySet()) {
                    String key = replacement.getKey();
                    Object value = replacement.getValue();
                    if (line == null) continue;
                    if (value instanceof List && line.contains("%" + key + "%")) {
                        int index = line.indexOf("%" + key + "%");
                        String prefix = line.substring(0, index);
                        String finalLine = line.substring(index);
                        ((List)value).forEach(currentValue -> {
                            String replacementValue = currentValue != null ? currentValue.toString() : "";
                            String currentElement = placeholders.parse(finalLine, key, replacementValue);
                            builder.append(placeholders.parse(prefix, key, replacementValue)).append(currentElement);
                            builder.append('\n');
                        });
                        line = null;
                        continue;
                    }
                    String replacementValue = value != null ? value.toString() : "";
                    line = placeholders.parse(line, key, replacementValue);
                }
                if (line == null) continue;
                builder.append(line);
                builder.append('\n');
            }
            loadConfiguration.loadFromString(builder.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return loadConfiguration;
    }

    protected static void clearConfigurationCache() {
        CONFIGURATION_CACHE.clear();
    }

    private static CachedLines getCachedLines(File file) throws IOException {
        Path path = file.toPath();
        long lastModified = file.lastModified();
        CachedLines cachedLines = CONFIGURATION_CACHE.get(path);
        if (cachedLines == null || cachedLines.lastModified() != lastModified) {
            List<String> lines = Files.readAllLines(path, Charsets.UTF_8);
            cachedLines = new CachedLines(lines, lastModified);
            CONFIGURATION_CACHE.put(path, cachedLines);
        }
        return cachedLines;
    }

    static {
        if (!NmsVersion.nmsVersion.isNewMaterial()) {
            byId = new Material[0];
            for (Material material : Material.values()) {
                if (byId.length <= material.getId()) {
                    byId = Arrays.copyOfRange(byId, 0, material.getId() + 2);
                }
                ZUtils.byId[material.getId()] = material;
            }
        }
    }

    private record CachedLines(List<String> lines, long lastModified) {
        private CachedLines {
            lines = List.copyOf(lines);
        }
    }
}

