/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.discord;

import fr.maxlego08.menu.zcore.utils.discord.DiscordWebhook;
import fr.maxlego08.menu.zcore.utils.discord.ReturnConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public record DiscordEmbedConfiguration(String title, String description, String url, Color color, Footer footer, Thumbnail thumbnail, Image image, Author author, List<Field> fields) {
    public static List<DiscordEmbedConfiguration> convertToEmbedObjects(List<Map<?, ?>> data) {
        ArrayList<DiscordEmbedConfiguration> embedObjects = new ArrayList<DiscordEmbedConfiguration>();
        for (Map<?, ?> map : data) {
            String title = DiscordEmbedConfiguration.getString(map, "title");
            String description = DiscordEmbedConfiguration.getString(map, "description");
            String url = DiscordEmbedConfiguration.getString(map, "url");
            Color color = DiscordEmbedConfiguration.hexToColor(DiscordEmbedConfiguration.getString(map, "color"));
            Footer footer = null;
            Map<?, ?> footerMap = DiscordEmbedConfiguration.getMap(map, "footer");
            if (footerMap != null) {
                String footerText = DiscordEmbedConfiguration.getString(footerMap, "text");
                String footerIconUrl = DiscordEmbedConfiguration.getString(footerMap, "icon-url");
                footer = new Footer(footerText, footerIconUrl);
            }
            Thumbnail thumbnail = null;
            Map<?, ?> thumbnailMap = DiscordEmbedConfiguration.getMap(map, "thumbnail");
            if (thumbnailMap != null) {
                String thumbnailUrl = DiscordEmbedConfiguration.getString(thumbnailMap, "url");
                thumbnail = new Thumbnail(thumbnailUrl);
            }
            Image image = null;
            Map<?, ?> imageMap = DiscordEmbedConfiguration.getMap(map, "image");
            if (imageMap != null) {
                String imageUrl = DiscordEmbedConfiguration.getString(imageMap, "url");
                image = new Image(imageUrl);
            }
            Author author = null;
            Map<?, ?> authorMap = DiscordEmbedConfiguration.getMap(map, "author");
            if (authorMap != null) {
                String authorName = DiscordEmbedConfiguration.getString(authorMap, "name");
                String authorUrl = DiscordEmbedConfiguration.getString(authorMap, "url");
                String authorIconUrl = DiscordEmbedConfiguration.getString(authorMap, "icon-url");
                author = new Author(authorName, authorUrl, authorIconUrl);
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            List<Map<String, Object>> fieldsList = DiscordEmbedConfiguration.getList(map, "fields");
            if (fieldsList != null) {
                for (Map map2 : fieldsList) {
                    String fieldName = DiscordEmbedConfiguration.getString(map2, "name");
                    String fieldValue = DiscordEmbedConfiguration.getString(map2, "value");
                    Boolean inline = DiscordEmbedConfiguration.getBoolean(map2, "inline");
                    fields.add(new Field(fieldName, fieldValue, inline != null ? inline : false));
                }
            }
            DiscordEmbedConfiguration embedObject = new DiscordEmbedConfiguration(title, description, url, color, footer, thumbnail, image, author, fields);
            embedObjects.add(embedObject);
        }
        return embedObjects;
    }

    private static String getString(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof String ? (String)value : null;
    }

    private static Map<?, ?> getMap(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof Map ? (Map)value : null;
    }

    private static List<Map<String, Object>> getList(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof List ? (List)value : null;
    }

    private static Boolean getBoolean(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    private static Color hexToColor(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6 && hex.length() != 8) {
            throw new IllegalArgumentException("Invalid hex color string");
        }
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        int a = 255;
        if (hex.length() == 8) {
            a = Integer.parseInt(hex.substring(6, 8), 16);
        }
        return new Color(r, g, b, a);
    }

    public void apply(ReturnConsumer<String, String> consumer, DiscordWebhook discordWebhook) {
        DiscordWebhook.EmbedObject embedObject = new DiscordWebhook.EmbedObject();
        if (this.author != null) {
            embedObject.setAuthor(consumer.accept(this.author.name()), consumer.accept(this.author.url()), consumer.accept(this.author.iconUrl()));
        }
        if (this.description != null) {
            embedObject.setDescription(consumer.accept(this.description));
        }
        if (this.color != null) {
            embedObject.setColor(this.color);
        }
        if (this.title != null) {
            embedObject.setTitle(consumer.accept(this.title));
        }
        if (this.thumbnail != null) {
            embedObject.setThumbnail(consumer.accept(this.thumbnail.url()));
        }
        if (this.image != null) {
            embedObject.setImage(consumer.accept(this.image.url()));
        }
        if (this.footer != null) {
            embedObject.setFooter(consumer.accept(this.footer.text()), consumer.accept(this.footer.iconUrl()));
        }
        if (!this.fields.isEmpty()) {
            for (Field field : this.fields) {
                embedObject.addField(consumer.accept(field.name()), consumer.accept(field.value()), field.inline());
            }
        }
        discordWebhook.addEmbed(embedObject);
    }

    public record Footer(String text, String iconUrl) {
    }

    public record Thumbnail(String url) {
    }

    public record Image(String url) {
    }

    public record Author(String name, String url, String iconUrl) {
    }

    public record Field(String name, String value, boolean inline) {
    }
}

