/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.discord;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class DiscordWebhookComponent {
    private final String url;
    private String avatarUrl;
    private String username;
    private List<?> json;

    public DiscordWebhookComponent(String url) {
        this.url = url;
    }

    public static int sendDiscordHttpRequest(JsonObject json, HttpURLConnection connection) throws IOException {
        connection.addRequestProperty("User-Agent", "Java-DiscordWebhook-BY-Gelox_");
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        OutputStream stream = connection.getOutputStream();
        String jsonString = new Gson().toJson((JsonElement)json);
        stream.write(jsonString.getBytes(StandardCharsets.UTF_8));
        stream.flush();
        stream.close();
        return connection.getResponseCode();
    }

    public void setJson(List<?> json) {
        this.json = json;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void execute() throws IOException {
        if (this.json == null) {
            throw new IllegalArgumentException("Json cannot be null");
        }
        JsonObject json = new JsonObject();
        if (this.username != null) {
            json.addProperty("username", this.username);
        }
        if (this.avatarUrl != null) {
            json.addProperty("avatar_url", this.avatarUrl);
        }
        json.addProperty("flags", (Number)32768);
        json.add("components", new Gson().toJsonTree(this.json));
        URL url = URI.create(this.url + "?with_components=true").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Content-Type", "application/json");
        int responseCode = DiscordWebhookComponent.sendDiscordHttpRequest(json, connection);
        if (responseCode != 204) {
            throw new IOException("Failed to send message: " + responseCode);
        }
        connection.getInputStream().close();
        connection.disconnect();
    }
}

