/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.itemstack;

import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.attribute.AttributeMergeStrategy;
import fr.maxlego08.menu.api.attribute.AttributeWrapper;
import fr.maxlego08.menu.api.enchantment.Enchantments;
import fr.maxlego08.menu.api.enchantment.MenuEnchantment;
import fr.maxlego08.menu.api.enums.MenuItemRarity;
import fr.maxlego08.menu.api.exceptions.ItemEnchantException;
import fr.maxlego08.menu.api.itemstack.TrimConfiguration;
import fr.maxlego08.menu.api.utils.TrimHelper;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class MenuItemStackFormMap {
    public static ZMenuItemStack fromMap(InventoryManager inventoryManager, File file, String path, Map<String, Object> map) {
        List<?> attributesFromConfig;
        Object object;
        TypedMapAccessor accessor = new TypedMapAccessor(map);
        ZMenuItemStack menuItemStack = new ZMenuItemStack(inventoryManager, file.getPath(), path);
        menuItemStack.setData(accessor.getString("data", "0"));
        menuItemStack.setDurability(accessor.getInt("durability", 0));
        menuItemStack.setAmount(accessor.getString("amount", "1"));
        menuItemStack.setMaterial(accessor.getString("material", null));
        menuItemStack.setTargetPlayer(accessor.getString("target", null));
        menuItemStack.setUrl(accessor.getString("url", null));
        List<String> lore = accessor.getStringList("lore");
        if (lore.isEmpty() && (object = accessor.getObject("lore", null)) instanceof String) {
            String loreString = (String)object;
            lore = Arrays.asList(loreString.split("\n"));
        }
        menuItemStack.setLore(lore);
        menuItemStack.setDisplayName(accessor.getString("name", accessor.getString("display_name", null)));
        menuItemStack.setGlowing(accessor.getBoolean("glow"));
        menuItemStack.setModelID(accessor.getString("modelID", accessor.getString("model-id", accessor.getString("modelId", accessor.getString("customModelId", accessor.getString("customModelData", accessor.getString("model_data", "0")))))));
        Enchantments helperEnchantments = inventoryManager.getEnchantments();
        List<String> enchants = accessor.getStringList("enchants");
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (String enchantString : enchants) {
            try {
                int level;
                String[] splitEnchant = enchantString.split(",");
                if (splitEnchant.length == 1) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString + " for file " + file.getAbsolutePath() + " with path " + path);
                }
                String enchant = splitEnchant[0];
                try {
                    level = Integer.parseInt(splitEnchant[1]);
                }
                catch (NumberFormatException e) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString + " for file " + file.getAbsolutePath() + " with path " + path);
                }
                Optional<MenuEnchantment> optional = helperEnchantments.getEnchantments(enchant);
                if (optional.isEmpty()) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString + " for file " + file.getAbsolutePath() + " with path " + path);
                }
                enchantments.put(optional.get().enchantment(), level);
            }
            catch (ItemEnchantException e) {
                e.printStackTrace();
            }
        }
        List<String> flagStrings = accessor.getStringList("flags");
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>(flagStrings.size());
        for (String flagName : flagStrings) {
            flags.add(menuItemStack.getFlag(flagName));
        }
        ArrayList<AttributeWrapper> attributeModifiers = new ArrayList<AttributeWrapper>();
        if (accessor.contains("attributes") && (attributesFromConfig = accessor.getList("attributes")) != null) {
            for (Map attributeMap : attributesFromConfig) {
                attributeModifiers.add(AttributeWrapper.deserialize(attributeMap));
            }
        }
        menuItemStack.setEnchantments(enchantments);
        menuItemStack.setFlags(flags);
        menuItemStack.setAttributeMergeStrategy(AttributeMergeStrategy.valueOf(accessor.getString("attribute-merge-strategy", "REPLACE").toUpperCase()));
        menuItemStack.setAttributes(attributeModifiers);
        if (NmsVersion.getCurrentVersion().isNewItemStackAPI()) {
            MenuItemStackFormMap.loadNewItemStacks(menuItemStack, accessor, path, file);
        }
        if (NmsVersion.getCurrentVersion().isNewHeadApi()) {
            MenuItemStackFormMap.loadTrims(menuItemStack, accessor, path, file);
        }
        return menuItemStack;
    }

    private static void loadNewItemStacks(ZMenuItemStack menuItemStack, TypedMapAccessor accessor, String path, File file) {
        menuItemStack.setMaxStackSize(accessor.getInt("max-stack-size", 0));
        menuItemStack.setMaxDamage(accessor.getInt("max-damage", 0));
        menuItemStack.setDamage(accessor.getInt("damage", 0));
        menuItemStack.setRepairCost(accessor.getInt("repair-cost", 0));
        menuItemStack.setUnbreakableEnabled(MenuItemStackFormMap.getOrNull(accessor.getObject("unbreakable", null)));
        menuItemStack.setUnbreakableShowInTooltip(MenuItemStackFormMap.getOrNull(accessor.getObject("unbreakable-show-in-tooltip", null)));
        menuItemStack.setFireResistant(MenuItemStackFormMap.getOrNull(accessor.getObject("fire-resistant", null)));
        menuItemStack.setHideTooltip(MenuItemStackFormMap.getOrNull(accessor.getObject("hide-tooltip", null)));
        menuItemStack.setHideAdditionalTooltip(MenuItemStackFormMap.getOrNull(accessor.getObject("hide-additional-tooltip", null)));
        menuItemStack.setEnchantmentGlint(MenuItemStackFormMap.getOrNull(accessor.getObject("enchantment-glint", null)));
        menuItemStack.setEnchantmentShowInTooltip(MenuItemStackFormMap.getOrNull(accessor.getObject("enchantment-show-in-tooltip", null)));
        menuItemStack.setAttributeShowInTooltip(MenuItemStackFormMap.getOrNull(accessor.getObject("attribute-show-in-tooltip", null)));
        String rarityString = accessor.getString("item-rarity", null);
        if (rarityString != null) {
            menuItemStack.setItemRarity(MenuItemRarity.valueOf(rarityString.toUpperCase()));
        }
    }

    private static void loadTrims(ZMenuItemStack menuItemStack, TypedMapAccessor accessor, String path, File file) {
        boolean enableTrim = accessor.getBoolean("trim.enable", false);
        if (enableTrim) {
            TrimMaterial trimMaterial;
            TrimHelper trimHelper = new TrimHelper();
            TrimPattern trimPattern = trimHelper.getTrimPatterns().get(accessor.getString("trim.pattern", "").toLowerCase());
            if (trimPattern == null) {
                enableTrim = false;
                Bukkit.getLogger().severe("Trim pattern " + accessor.getString("trim.pattern", "") + " was not found for item " + file.getAbsolutePath());
            }
            if ((trimMaterial = trimHelper.getTrimMaterials().get(accessor.getString("trim.material", "").toLowerCase())) == null) {
                enableTrim = false;
                Bukkit.getLogger().severe("Trim material " + accessor.getString("trim.material", "") + " was not found for item " + file.getAbsolutePath());
            }
            menuItemStack.setTrimConfiguration(new TrimConfiguration(enableTrim, trimMaterial, trimPattern));
        }
    }

    private static Boolean getOrNull(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }
}

