/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.itemstack;

import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.itemstack.Firework;
import fr.maxlego08.menu.api.itemstack.Potion;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionType;

public class MenuItemStackFromItemStack {
    public static ZMenuItemStack fromItemStack(InventoryManager manager, ItemStack itemStack) {
        ItemMeta itemMeta;
        ZMenuItemStack menuItemStack = new ZMenuItemStack(manager, "", "");
        menuItemStack.setMaterial(itemStack.getType().name());
        int amount = itemStack.getAmount();
        if (amount > 1) {
            menuItemStack.setAmount(String.valueOf(itemStack.getAmount()));
        }
        if (NmsVersion.getCurrentVersion().isItemLegacy()) {
            byte data;
            short durability = itemStack.getDurability();
            if (durability > 0) {
                menuItemStack.setDurability(durability);
            }
            if ((data = itemStack.getData().getData()) > 0) {
                menuItemStack.setData(String.valueOf(data));
            }
        }
        if ((itemMeta = itemStack.getItemMeta()) != null) {
            EnchantmentStorageMeta enchantmentStorageMeta;
            if (itemMeta.hasDisplayName()) {
                menuItemStack.setDisplayName(menuItemStack.colorReverse(itemMeta.getDisplayName()));
            }
            if (itemMeta.hasLore()) {
                menuItemStack.setLore(menuItemStack.colorReverse(Objects.requireNonNull(itemMeta.getLore())));
            }
            menuItemStack.setFlags(new ArrayList<ItemFlag>(itemMeta.getItemFlags()));
            menuItemStack.setEnchantments(itemMeta.getEnchants());
            if (NmsVersion.getCurrentVersion().isCustomModelData() && itemMeta.hasCustomModelData()) {
                menuItemStack.setModelID(itemMeta.getCustomModelData());
            }
            if (itemMeta instanceof SkullMeta) {
                SkullMeta data = (SkullMeta)itemMeta;
            }
            if (itemMeta instanceof EnchantmentStorageMeta && (enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta).hasStoredEnchants()) {
                menuItemStack.setEnchantments(enchantmentStorageMeta.getEnchants());
            }
            try {
                PotionMeta potionMeta;
                PotionType type;
                if (itemMeta instanceof PotionMeta && (type = (potionMeta = (PotionMeta)itemMeta).getBasePotionType()) != null) {
                    Potion menuPotion = new Potion(type, 0);
                    menuItemStack.setPotion(menuPotion);
                }
            }
            catch (Exception potionMeta) {
                // empty catch block
            }
            try {
                FireworkMeta fireworkMeta;
                List fireworkEffects;
                if (itemMeta instanceof FireworkMeta && !(fireworkEffects = (fireworkMeta = (FireworkMeta)itemMeta).getEffects()).isEmpty()) {
                    FireworkEffect effect = (FireworkEffect)fireworkEffects.getFirst();
                    Firework menuFirework = new Firework(false, effect);
                    menuItemStack.setFirework(menuFirework);
                }
            }
            catch (Exception fireworkMeta) {
                // empty catch block
            }
            try {
                if (itemMeta instanceof FireworkEffectMeta) {
                    FireworkEffectMeta fireworkMeta = (FireworkEffectMeta)itemMeta;
                    FireworkEffect effect = fireworkMeta.getEffect();
                    Firework menuFirework = new Firework(true, effect);
                    menuItemStack.setFirework(menuFirework);
                }
            }
            catch (Exception fireworkMeta) {
                // empty catch block
            }
            if (!itemMeta.getPersistentDataContainer().getKeys().isEmpty()) {
                String base64 = ItemStackUtils.serializeItemStack(itemStack);
                menuItemStack.setMaterial("base64:" + base64);
            }
        }
        return menuItemStack;
    }
}

