/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.storage;

import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.zcore.ZPlugin;
import fr.maxlego08.menu.zcore.enums.Folder;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.storage.DiscUtils;
import java.io.File;
import java.lang.reflect.Type;

public class Persist
extends ZUtils {
    private final ZPlugin plugin;

    public Persist(ZPlugin plugin) {
        this.plugin = plugin;
    }

    public static String getName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public static String getName(Object o) {
        return Persist.getName(o.getClass());
    }

    public static String getName(Type type) {
        return Persist.getName(type.getClass());
    }

    public File getFile(String name) {
        return new File(this.plugin.getDataFolder(), name + ".json");
    }

    public File getFile(Class<?> clazz) {
        return this.getFile(Persist.getName(clazz));
    }

    public File getFile(Object obj) {
        return this.getFile(Persist.getName(obj));
    }

    public File getFile(Type type) {
        return this.getFile(Persist.getName(type));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(clazz));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, String name) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(name));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, Folder folder, String name) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(folder.toFolder() + File.separator + name));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, File file) {
        if (!file.exists()) {
            this.plugin.getLog().log("Creating default: " + String.valueOf(file), Logger.LogType.SUCCESS);
            this.save(def, file);
            return def;
        }
        T loaded = this.load(clazz, file);
        if (loaded == null) {
            this.plugin.getLog().log("Using default as I failed to load: " + String.valueOf(file), Logger.LogType.WARNING);
            File backup = new File(file.getPath() + "_bad");
            if (backup.exists()) {
                backup.delete();
            }
            this.plugin.getLog().log("Backing up copy of bad file to: " + String.valueOf(backup), Logger.LogType.WARNING);
            file.renameTo(backup);
            return def;
        }
        if (Config.enableLogStorageFile) {
            this.plugin.getLog().log(file.getPath() + " loaded successfully !", Logger.LogType.SUCCESS);
        }
        return loaded;
    }

    public boolean save(Object instance) {
        return this.save(instance, this.getFile(instance));
    }

    public boolean save(Object instance, String name) {
        return this.save(instance, this.getFile(name));
    }

    public boolean save(Object instance, Folder folder, String name) {
        return this.save(instance, this.getFile(folder.toFolder() + File.separator + name));
    }

    public boolean save(Object instance, File file) {
        try {
            boolean b = DiscUtils.writeCatch(file, this.plugin.getGson().toJson(instance));
            if (Config.enableLogStorageFile) {
                this.plugin.getLog().log(file.getAbsolutePath() + " successfully saved !", Logger.LogType.SUCCESS);
            }
            return b;
        }
        catch (Exception e) {
            this.plugin.getLog().log("cannot save file " + file.getAbsolutePath(), Logger.LogType.ERROR);
            e.printStackTrace();
            return false;
        }
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, this.getFile(clazz));
    }

    public <T> T load(Class<T> clazz, String name) {
        return this.load(clazz, this.getFile(name));
    }

    public <T> T load(Class<T> clazz, File file) {
        String content = DiscUtils.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            return (T)this.plugin.getGson().fromJson(content, clazz);
        }
        catch (Exception ex) {
            this.plugin.getLog().log(ex.getMessage(), Logger.LogType.ERROR);
            return null;
        }
    }

    public <T> T load(Type typeOfT, String name) {
        return this.load(typeOfT, this.getFile(name));
    }

    public <T> T load(Type typeOfT, File file) {
        String content = DiscUtils.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            return (T)this.plugin.getGson().fromJson(content, typeOfT);
        }
        catch (Exception ex) {
            this.plugin.getLog().log(ex.getMessage(), Logger.LogType.ERROR);
            return null;
        }
    }
}

