/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class Logic10 {
    private static final int REQUIRED_CLICKS = 5;
    private static final Map<BlockPos, Integer> FIRE_CLICK_COUNTS = new HashMap<BlockPos, Integer>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic10());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLeftClickFire(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.FIRE) || state.is(Blocks.SOUL_FIRE)) {
            int count = FIRE_CLICK_COUNTS.getOrDefault(pos, 0) + 1;
            FIRE_CLICK_COUNTS.put(pos, count);
            if (player2.getMainHandItem().isEmpty()) {
                player2.hurt(player2.damageSources().generic(), 2.0f);
            }
            if (count < 5) {
                event.setCanceled(true);
            } else {
                FIRE_CLICK_COUNTS.remove(pos);
            }
        }
    }
}

