/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic11 {
    private static boolean active = false;
    private static final double ARROW_SCAN_RADIUS = 96.0;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic11());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player tickingPlayer = event.getEntity();
        Level level = tickingPlayer.level();
        if (level.isClientSide()) {
            return;
        }
        AABB box = tickingPlayer.getBoundingBox().inflate(96.0);
        for (AbstractArrow arrow : level.getEntitiesOfClass(AbstractArrow.class, box)) {
            Skeleton skeleton;
            LivingEntity target;
            Entity owner = arrow.getOwner();
            if (!(owner instanceof Skeleton) || (target = (skeleton = (Skeleton)owner).getTarget()) == null || !target.isAlive()) continue;
            Vec3 from = arrow.position();
            Vec3 to = target.getEyePosition();
            Vec3 dir = to.subtract(from);
            if (dir.lengthSqr() < 1.0E-6) continue;
            dir = dir.normalize();
            double currentSpeed = arrow.getDeltaMovement().length();
            if (currentSpeed < 0.1) {
                currentSpeed = 1.6;
            }
            arrow.shoot(dir.x, dir.y, dir.z, (float)currentSpeed, 0.0f);
        }
    }
}

