/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic18 {
    private static final Map<UUID, Long> NEXT_SPAWN_TICK = new HashMap<UUID, Long>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic18());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        boolean isRainingHere;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        UUID id = player.getUUID();
        long now = level.getGameTime();
        boolean bl = isRainingHere = level.isRaining() && level.isRainingAt(player.blockPosition());
        if (!isRainingHere) {
            NEXT_SPAWN_TICK.remove(id);
            return;
        }
        long next = NEXT_SPAWN_TICK.getOrDefault(id, now);
        if (now < next) {
            return;
        }
        NEXT_SPAWN_TICK.put(id, now + 50L);
        double radius = 30.0;
        double angle = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
        double distance = Math.sqrt(ThreadLocalRandom.current().nextDouble()) * radius;
        int dx = (int)Math.round(Math.cos(angle) * distance);
        int dz = (int)Math.round(Math.sin(angle) * distance);
        int x = (int)Math.floor(player.getX()) + dx;
        int z = (int)Math.floor(player.getZ()) + dz;
        int topY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        int maxBuildY = level.dimensionType().minY() + level.dimensionType().logicalHeight();
        int spawnY = Math.min(maxBuildY - 2, topY + 20);
        double spawnX = (double)x + 0.5;
        double spawnZ = (double)z + 0.5;
        PrimedTnt tnt = new PrimedTnt((Level)level, spawnX, (double)spawnY, spawnZ, null);
        level.addFreshEntity((Entity)tnt);
    }
}

