/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class Logic21 {
    private static final Map<UUID, Integer> SLEEP_TICKS = new HashMap<UUID, Integer>();
    private static final Map<UUID, BlockPos> SLEEP_BED_POS = new HashMap<UUID, BlockPos>();
    private static final int REQUIRED_SLEEP_TICKS = 1200;
    private static final Set<ResourceKey<Level>> FROZEN_LEVELS = new HashSet<ResourceKey<Level>>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic21());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        GameRules.BooleanValue rule;
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean hasEnforcedSleep = serverLevel.players().stream().anyMatch(p -> SLEEP_TICKS.containsKey(p.getUUID()));
        GameRules.BooleanValue daylightRule = (GameRules.BooleanValue)serverLevel.getGameRules().getRule(GameRules.RULE_DAYLIGHT);
        ResourceKey dim = serverLevel.dimension();
        if (hasEnforcedSleep) {
            if (!daylightRule.get() || FROZEN_LEVELS.contains(dim)) {
                FROZEN_LEVELS.add((ResourceKey<Level>)dim);
            } else {
                daylightRule.set(false, serverLevel.getServer());
                FROZEN_LEVELS.add((ResourceKey<Level>)dim);
            }
        }
        for (Player player : serverLevel.players()) {
            int secondsLeft;
            ServerPlayer sp;
            UUID id = player.getUUID();
            if (player.isSleeping()) {
                long currentDayBase;
                long nextMorning;
                int ticks = SLEEP_TICKS.getOrDefault(id, 0) + 1;
                SLEEP_TICKS.put(id, ticks);
                Optional sleepPos = player.getSleepingPos();
                sleepPos.ifPresent(pos -> SLEEP_BED_POS.put(id, (BlockPos)pos));
                if (player instanceof ServerPlayer) {
                    sp = (ServerPlayer)player;
                    secondsLeft = Math.max(0, (1200 - ticks) / 20);
                    sp.displayClientMessage((Component)Component.literal((String)("You can't get up! Left: " + secondsLeft + "s")), true);
                }
                if (ticks < 1200) continue;
                long current = serverLevel.getDayTime();
                if (current >= (nextMorning = (currentDayBase = current / 24000L * 24000L) + 1000L)) {
                    nextMorning = currentDayBase + 24000L + 1000L;
                }
                serverLevel.setDayTime(nextMorning);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp2 = (ServerPlayer)player;
                    sp2.stopSleeping();
                    sp2.displayClientMessage((Component)Component.literal((String)"Wake up! Morning came."), true);
                }
                SLEEP_TICKS.remove(id);
                SLEEP_BED_POS.remove(id);
                continue;
            }
            Integer ticks = SLEEP_TICKS.get(id);
            BlockPos bedPos = SLEEP_BED_POS.get(id);
            if (ticks != null && ticks < 1200 && bedPos != null) {
                if (this.isBedAt(serverLevel, bedPos) && player.distanceToSqr((double)bedPos.getX() + 0.5, (double)bedPos.getY() + 0.5, (double)bedPos.getZ() + 0.5) < 9.0) {
                    if (!(player instanceof ServerPlayer)) continue;
                    sp = (ServerPlayer)player;
                    sp.startSleeping(bedPos);
                    secondsLeft = Math.max(0, (1200 - ticks) / 20);
                    sp.displayClientMessage((Component)Component.literal((String)("You can't get up! Left: " + secondsLeft + "s")), true);
                    continue;
                }
                SLEEP_TICKS.remove(id);
                SLEEP_BED_POS.remove(id);
                continue;
            }
            SLEEP_TICKS.remove(id);
            SLEEP_BED_POS.remove(id);
        }
        boolean anyRemaining = serverLevel.players().stream().anyMatch(p -> SLEEP_TICKS.containsKey(p.getUUID()));
        if (!anyRemaining && FROZEN_LEVELS.remove(dim) && !(rule = (GameRules.BooleanValue)serverLevel.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).get()) {
            rule.set(true, serverLevel.getServer());
        }
    }

    private boolean isBedAt(ServerLevel serverLevel, BlockPos bedPos) {
        BlockState state = serverLevel.getBlockState(bedPos);
        return state.getBlock() instanceof BedBlock;
    }
}

