/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic23 {
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic23());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        double radius = 16.0;
        List wolves = level.getEntitiesOfClass(Wolf.class, player.getBoundingBox().inflate(radius));
        if (wolves.isEmpty()) {
            return;
        }
        for (Wolf wolf : wolves) {
            if (wolf.getOwner() != null) continue;
            wolf.setTarget((LivingEntity)player);
        }
    }

    @SubscribeEvent
    public void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        Entity source;
        LivingEntity target = event.getEntity();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        Entity entity = source = event.getSource() != null ? event.getSource().getEntity() : null;
        if (!(source instanceof Wolf)) {
            return;
        }
        if (player.level().isClientSide()) {
            return;
        }
        if (player.getRandom().nextFloat() < 0.5f) {
            player.setRemainingFireTicks(100);
        }
    }
}

