/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class Logic24 {
    private static int tickCounter = 0;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic24());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLevelLoad(LevelEvent.Load event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        this.enforceHard(level.getServer());
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (tickCounter++ % 100 == 0) {
            this.enforceHard(server);
        }
    }

    private void enforceHard(MinecraftServer server) {
        if (server == null) {
            return;
        }
        try {
            server.getWorldData().setDifficulty(Difficulty.HARD);
            server.getWorldData().setDifficultyLocked(true);
            server.setDifficulty(Difficulty.HARD, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

