/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic28 {
    private static final Set<UUID> IN_VILLAGE = new HashSet<UUID>();
    private static final int CHECK_EVERY_TICKS = 20;
    private static final int VILLAGE_RADIUS = 48;
    private static final int NEARBY_RAID_RADIUS = 64;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic28());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.tickCount % 20 != 0) {
            return;
        }
        Level level = player2.level();
        if (level.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UUID id = player2.getUUID();
        boolean wasInVillage = IN_VILLAGE.contains(id);
        boolean nowInVillage = this.isInVillage(serverLevel, player2.blockPosition());
        if (nowInVillage) {
            IN_VILLAGE.add(id);
        } else {
            IN_VILLAGE.remove(id);
        }
        if (!wasInVillage && nowInVillage) {
            if (this.hasNearbyRaid(serverLevel, player2.blockPosition(), 64)) {
                return;
            }
            if (serverLevel.random.nextFloat() < 0.5f) {
                this.tryStartRaid(serverLevel, player2);
            }
        }
    }

    private boolean isInVillage(ServerLevel level, BlockPos pos) {
        long meetings;
        int radius;
        PoiManager poi = level.getPoiManager();
        long homes = poi.getCountInRange(p -> p.is(PoiTypes.HOME), pos, radius = 48, PoiManager.Occupancy.ANY);
        return homes + (meetings = poi.getCountInRange(p -> p.is(PoiTypes.MEETING), pos, radius, PoiManager.Occupancy.ANY)) > 0L;
    }

    private boolean hasNearbyRaid(ServerLevel level, BlockPos pos, int radius) {
        try {
            boolean b = level.getRaidAt(pos) != null;
            return b;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void tryStartRaid(ServerLevel level, ServerPlayer player) {
        try {
            player.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, 200, 0, false, false, false));
            Raid raid = level.getRaids().createOrExtendRaid(player, player.blockPosition());
            if (raid != null) {
                player.removeEffect(MobEffects.BAD_OMEN);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

