/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic30 {
    private static final Map<UUID, Integer> PREV_AIR = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> LAST_DMG_TICK = new HashMap<UUID, Long>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic30());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        long interval;
        long last;
        long now;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        UUID id = player.getUUID();
        int current = player.getAirSupply();
        int maxAir = player.getMaxAirSupply();
        Integer prevBoxed = PREV_AIR.get(id);
        if (prevBoxed == null) {
            PREV_AIR.put(id, current);
            return;
        }
        int prev = prevBoxed;
        int vanillaDelta = current - prev;
        boolean hasWaterBreathing = player.hasEffect(MobEffects.WATER_BREATHING);
        boolean underwater = player.isEyeInFluid(FluidTags.WATER) && !hasWaterBreathing;
        int targetDelta = vanillaDelta;
        if (underwater && vanillaDelta <= 0) {
            targetDelta = vanillaDelta * 3;
        } else if (!underwater && vanillaDelta > 0) {
            targetDelta = Math.max(1, (int)Math.ceil((double)vanillaDelta / 5.0));
        }
        int adjusted = prev + targetDelta;
        if (adjusted != current) {
            adjusted = Math.max(0, Math.min(maxAir, adjusted));
            player.setAirSupply(adjusted);
            current = adjusted;
        }
        if (underwater && current <= 0 && (now = ((ServerLevel)player.level()).getGameTime()) - (last = LAST_DMG_TICK.getOrDefault(id, 0L).longValue()) >= (interval = 5L)) {
            player.hurt(player.damageSources().drown(), 1.0f);
            LAST_DMG_TICK.put(id, now);
        }
        PREV_AIR.put(id, current);
    }
}

