/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

public class Logic33 {
    private static volatile boolean registered = false;
    private static boolean active = false;
    private static final List<EntityType<?>> POSSIBLE_MOBS = List.of(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.CREEPER, EntityType.SPIDER, EntityType.ENDERMAN, EntityType.WITCH, EntityType.HUSK, EntityType.STRAY, EntityType.DROWNED, EntityType.ZOMBIE_VILLAGER, EntityType.PILLAGER);
    private static final double BASE_GENERATE_CHANCE = 0.02;
    private static volatile int spawnFrequency = 1;

    public static void init() {
        if (registered) {
            return;
        }
        NeoForge.EVENT_BUS.register((Object)new Logic33());
        registered = true;
    }

    public static void run(Player player) {
        active = true;
    }

    public static void setSpawnFrequency(int value) {
        if (value < 0) {
            value = 0;
        }
        spawnFrequency = value;
    }

    public static int getSpawnFrequency() {
        return spawnFrequency;
    }

    private double effectiveGenerateChance() {
        if (spawnFrequency <= 0) {
            return 0.0;
        }
        return Math.min(0.75, 0.02 * (double)spawnFrequency);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        int z;
        int y;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        RandomSource random = level.random;
        if (random.nextDouble() > this.effectiveGenerateChance()) {
            return;
        }
        int chunkMinX = ((LevelChunk)event.getChunk()).getPos().getMinBlockX();
        int chunkMinZ = ((LevelChunk)event.getChunk()).getPos().getMinBlockZ();
        int x = chunkMinX + random.nextInt(16);
        BlockPos basePos = new BlockPos(x, y = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z = chunkMinZ + random.nextInt(16)), z);
        BlockPos center = this.findValidCenterAroundSurface(level, basePos, 8, 32, level.random);
        if (center == null) {
            center = this.findValidCenter(level, basePos, 24);
        }
        if (center == null) {
            return;
        }
        this.placeSpawnerCage(level, center, random);
    }

    private boolean isValidPlacement(ServerLevel level, BlockPos center) {
        BlockPos below = center.below();
        BlockState belowState = level.getBlockState(below);
        if (!belowState.isSolid() || !this.isValidFoundation(belowState)) {
            return false;
        }
        return this.canCarveCageVolume(level, center);
    }

    private boolean canCarveCageVolume(ServerLevel level, BlockPos center) {
        for (int dy = 0; dy <= 2; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos p = center.offset(dx, dy, dz);
                    if (!level.isInWorldBounds(p)) {
                        return false;
                    }
                    BlockState st = level.getBlockState(p);
                    if (st.is(Blocks.BEDROCK)) {
                        return false;
                    }
                    if (level.getFluidState(p).isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private BlockPos findValidCenter(ServerLevel level, BlockPos start, int maxDepth) {
        int x = start.getX();
        int z = start.getZ();
        int startY = start.getY();
        int minY = Math.max(-61, startY - maxDepth);
        for (int y = startY; y >= minY; --y) {
            BlockPos candidate = new BlockPos(x, y, z);
            if (!this.isValidPlacement(level, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private BlockPos findValidCenterAroundSurface(ServerLevel level, BlockPos base, int radius, int attempts, RandomSource random) {
        int baseX = base.getX();
        int baseZ = base.getZ();
        for (int i = 0; i < attempts; ++i) {
            int dz;
            int cz;
            int cy;
            int dx = random.nextInt(radius * 2 + 1) - radius;
            int cx = baseX + dx;
            BlockPos candidate = new BlockPos(cx, cy = level.getHeight(Heightmap.Types.WORLD_SURFACE, cx, cz = baseZ + (dz = random.nextInt(radius * 2 + 1) - radius)), cz);
            if (!this.isValidPlacement(level, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private boolean isValidFoundation(BlockState belowState) {
        if (belowState.is(BlockTags.LEAVES)) {
            return false;
        }
        if (belowState.is(Blocks.COBWEB)) {
            return false;
        }
        if (belowState.is(Blocks.VINE)) {
            return false;
        }
        if (belowState.is(Blocks.SWEET_BERRY_BUSH)) {
            return false;
        }
        if (belowState.is(Blocks.CAVE_VINES) || belowState.is(Blocks.CAVE_VINES_PLANT)) {
            return false;
        }
        return !belowState.is(Blocks.SNOW);
    }

    private void placeSpawnerCage(ServerLevel level, BlockPos center, RandomSource random) {
        level.setBlock(center, Blocks.SPAWNER.defaultBlockState(), 3);
        BlockEntity be = level.getBlockEntity(center);
        if (be instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)be;
            BaseSpawner logic = spawner.getSpawner();
            EntityType<?> type = POSSIBLE_MOBS.get(random.nextInt(POSSIBLE_MOBS.size()));
            logic.setEntityId(type, (Level)level, level.getRandom(), center);
            int spawnCount = 2 + random.nextInt(4);
            this.trySetSpawnerIntField(logic, "spawnCount", spawnCount);
            this.trySetSpawnerIntField(logic, "minSpawnDelay", 80 + random.nextInt(200));
            this.trySetSpawnerIntField(logic, "maxSpawnDelay", 300 + random.nextInt(600));
            this.trySetSpawnerIntField(logic, "maxNearbyEntities", 6 + random.nextInt(7));
            this.trySetSpawnerIntField(logic, "requiredPlayerRange", 12 + random.nextInt(16));
            this.trySetSpawnerIntField(logic, "spawnRange", 4 + random.nextInt(5));
            spawner.setChanged();
        }
        for (int dy = 0; dy <= 2; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    boolean isPerimeter = Math.abs(dx) == 1 || Math.abs(dz) == 1;
                    BlockPos p = center.offset(dx, dy, dz);
                    if (dy < 2) {
                        if (isPerimeter) {
                            this.placeIronBars((LevelAccessor)level, p);
                            continue;
                        }
                        if (p.equals((Object)center)) continue;
                        level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
                        continue;
                    }
                    this.placeCageStone((LevelAccessor)level, p, random);
                }
            }
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos floor = center.offset(dx, -1, dz);
                this.placeCageStone((LevelAccessor)level, floor, random);
            }
        }
    }

    private void placeIronBars(LevelAccessor level, BlockPos pos) {
        BlockState state = Blocks.IRON_BARS.defaultBlockState();
        level.setBlock(pos, state, 3);
    }

    private boolean isCageFloorBlock(LevelAccessor level, BlockPos pos) {
        BlockPos above = pos.above();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos candidateCenter = above.offset(dx, 0, dz);
                if (!level.getBlockState(candidateCenter).is(Blocks.SPAWNER)) continue;
                int bars = 0;
                for (int ddx = -1; ddx <= 1; ++ddx) {
                    for (int ddz = -1; ddz <= 1; ++ddz) {
                        BlockPos barPos;
                        if (Math.abs(ddx) != 1 && Math.abs(ddz) != 1 || !level.getBlockState(barPos = candidateCenter.offset(ddx, 0, ddz)).is(Blocks.IRON_BARS)) continue;
                        ++bars;
                    }
                }
                return bars >= 8;
            }
        }
        return false;
    }

    private boolean isCageBarBlock(LevelAccessor level, BlockPos pos) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dy = -2; dy <= 2; ++dy) {
                    BlockPos sPos = pos.offset(dx, dy, dz);
                    if (!level.getBlockState(sPos).is(Blocks.SPAWNER)) continue;
                    int offX = pos.getX() - sPos.getX();
                    int offY = pos.getY() - sPos.getY();
                    int offZ = pos.getZ() - sPos.getZ();
                    if (offY != 0 && offY != 1 || Math.abs(offX) > 1 || Math.abs(offZ) > 1 || Math.abs(offX) != 1 && Math.abs(offZ) != 1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCageStoneBlock(LevelAccessor level, BlockPos pos) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dy = -3; dy <= 3; ++dy) {
                    BlockPos sPos = pos.offset(dx, dy, dz);
                    if (!level.getBlockState(sPos).is(Blocks.SPAWNER)) continue;
                    int offX = pos.getX() - sPos.getX();
                    int offZ = pos.getZ() - sPos.getZ();
                    if (pos.getY() == sPos.getY() - 1 && Math.abs(offX) <= 1 && Math.abs(offZ) <= 1) {
                        return true;
                    }
                    if (pos.getY() != sPos.getY() + 2 || Math.abs(offX) > 1 || Math.abs(offZ) > 1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCageRoofBlock(LevelAccessor level, BlockPos pos) {
        BlockPos below2 = pos.below(2);
        if (level.getBlockState(below2).is(Blocks.SPAWNER)) {
            int bars = 0;
            for (int ddx = -1; ddx <= 1; ++ddx) {
                for (int ddz = -1; ddz <= 1; ++ddz) {
                    BlockPos barPos;
                    if (Math.abs(ddx) != 1 && Math.abs(ddz) != 1 || !level.getBlockState(barPos = below2.offset(ddx, 0, ddz)).is(Blocks.IRON_BARS)) continue;
                    ++bars;
                }
            }
            return bars >= 8;
        }
        return false;
    }

    private void placeCageStone(LevelAccessor level, BlockPos pos, RandomSource random) {
        BlockState choice = random.nextFloat() < 0.3f ? Blocks.MOSSY_COBBLESTONE.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState();
        level.setBlock(pos, choice, 3);
    }

    private void trySetSpawnerIntField(BaseSpawner spawner, String fieldName, int value) {
        try {
            Field f = BaseSpawner.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.setInt(spawner, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        Player player = event.getPlayer();
        if (player != null && state.is(Blocks.IRON_BARS) && this.isCageBarBlock(event.getLevel(), event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (player != null && (state.is(Blocks.COBBLESTONE) || state.is(Blocks.MOSSY_COBBLESTONE))) {
            BlockPos p = event.getPos();
            if (this.isCageStoneBlock(event.getLevel(), p)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
    }
}

