/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class Logic34 {
    private static volatile boolean registered = false;
    private static boolean active = false;
    private static final String TAG_LAST_SHOT_TICK = "complicatedminecraftmod_blaze_last_shot";
    private static final int SHOT_INTERVAL_TICKS = 10;

    public static void init() {
        if (registered) {
            return;
        }
        NeoForge.EVENT_BUS.register((Object)new Logic34());
        registered = true;
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Blaze)) {
            return;
        }
        Blaze blaze = (Blaze)entity;
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity target = blaze.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        int tickCount = blaze.tickCount;
        CompoundTag tag = blaze.getPersistentData();
        int last = tag.getInt(TAG_LAST_SHOT_TICK).orElse(0);
        if (tickCount - last < 10) {
            return;
        }
        Vec3 eye = blaze.getEyePosition();
        Vec3 targetEye = target.getEyePosition();
        Vec3 dir = targetEye.subtract(eye).normalize();
        double speed = 0.6;
        Vec3 spawnPos = eye.add(dir.scale(0.6));
        SmallFireball fireball = new SmallFireball((Level)level2, spawnPos.x, spawnPos.y, spawnPos.z, dir.scale(speed));
        fireball.setOwner((Entity)blaze);
        level2.addFreshEntity((Entity)fireball);
        tag.putInt(TAG_LAST_SHOT_TICK, tickCount);
    }
}

