/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class Logic36 {
    private static boolean active = true;

    public static void run(Player player) {
    }

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic36());
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ResourceKey toDim = event.getTo();
        if (toDim != Level.END) {
            return;
        }
        ServerLevel level = player2.serverLevel();
        level.getServer().execute(() -> Logic36.buildSmallEndPlatform(level, player2.blockPosition().below()));
    }

    private static void buildSmallEndPlatform(ServerLevel level, BlockPos center) {
        int y = center.getY();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                boolean keep;
                BlockPos floorPos = new BlockPos(center.getX() + dx, y, center.getZ() + dz);
                boolean bl = keep = Math.abs(dx) <= 1 && Math.abs(dz) <= 1;
                if (keep) {
                    level.setBlockAndUpdate(floorPos, Blocks.BEDROCK.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(floorPos, Blocks.AIR.defaultBlockState());
                }
                for (int dy = 1; dy <= 3; ++dy) {
                    BlockPos airPos = floorPos.above(dy);
                    level.setBlockAndUpdate(airPos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }

    public static void run(ServerPlayer player) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (level2.dimension() != Level.END) {
            return;
        }
        Logic36.buildSmallEndPlatform(level2, player.blockPosition().below());
    }
}

