/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class Logic37 {
    private static boolean registered = false;
    private static boolean active = true;
    private static final Map<ResourceKey<Level>, Map<BlockPos, Long>> SCHEDULE = new HashMap<ResourceKey<Level>, Map<BlockPos, Long>>();
    private static final Map<ResourceKey<Level>, Set<BlockPos>> MANAGED = new HashMap<ResourceKey<Level>, Set<BlockPos>>();

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic37());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!active) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = event.getPos();
        BlockState state = level2.getBlockState(pos);
        if (!Logic37.isManaged((ResourceKey<Level>)level2.dimension(), pos) || !Logic37.isAnyRedstoneTorch(state)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack == null || !stack.is(Items.FLINT_AND_STEEL)) {
            return;
        }
        BlockState relit = state.getBlock() instanceof WallTorchBlock ? (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))) : Blocks.TORCH.defaultBlockState();
        level2.setBlock(pos, relit, 3);
        Logic37.unmarkManaged((ResourceKey<Level>)level2.dimension(), pos);
        SCHEDULE.computeIfAbsent((ResourceKey<Level>)level2.dimension(), d -> new HashMap()).put(pos.immutable(), level2.getGameTime() + 6000L);
        Player player = event.getEntity();
        if (player != null) {
            InteractionHand hand = event.getHand();
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            stack.hurtAndBreak(1, (LivingEntity)player, slot);
        }
        event.setCanceled(true);
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    public static void run(ServerPlayer player) {
        active = true;
        if (player != null && player.server != null) {
            ServerLevel level = player.serverLevel();
            Logic37.pruneManaged(level);
            ResourceKey dim = level.dimension();
            int scheduled = SCHEDULE.getOrDefault(dim, Collections.emptyMap()).size();
            int n = MANAGED.getOrDefault(dim, Collections.emptySet()).size();
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!active) {
            return;
        }
        LevelAccessor lvlAcc = event.getLevel();
        if (lvlAcc.isClientSide()) {
            return;
        }
        BlockState placed = event.getPlacedBlock();
        if (!placed.is(Blocks.REDSTONE_TORCH) && !placed.is(Blocks.REDSTONE_WALL_TORCH) && lvlAcc instanceof ServerLevel) {
            ServerLevel sl0 = (ServerLevel)lvlAcc;
            Logic37.unmarkManaged((ResourceKey<Level>)sl0.dimension(), event.getPos());
        }
        if (!Logic37.isAnyTorch(placed)) {
            return;
        }
        if (!(lvlAcc instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)lvlAcc;
        long when = serverLevel.getGameTime() + 6000L;
        ResourceKey dim = serverLevel.dimension();
        BlockPos pos = event.getPos().immutable();
        SCHEDULE.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashMap()).put(pos, when);
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        if (!active) {
            return;
        }
        Level lvlAcc2 = event.getLevel();
        if (lvlAcc2.isClientSide()) {
            return;
        }
        if (!(lvlAcc2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)lvlAcc2;
        Map<BlockPos, Long> byPos = SCHEDULE.get(level.dimension());
        if (byPos == null || byPos.isEmpty()) {
            return;
        }
        long now = level.getGameTime();
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Long> e : byPos.entrySet()) {
            if (now < e.getValue()) continue;
            BlockPos pos = e.getKey();
            BlockState state = level.getBlockState(pos);
            if (Logic37.isAnyTorch(state)) {
                BlockState newState = state.getBlock() instanceof WallTorchBlock ? (BlockState)Blocks.REDSTONE_WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))) : Blocks.REDSTONE_TORCH.defaultBlockState();
                newState = Logic37.forceOff(newState);
                level.setBlock(pos, newState, 3);
                Logic37.markManaged((ResourceKey<Level>)level.dimension(), pos);
            }
            toRemove.add(pos);
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(byPos::remove);
            if (byPos.isEmpty()) {
                SCHEDULE.remove(level.dimension());
            }
        }
    }

    @SubscribeEvent
    public void onNeighbors(BlockEvent.NeighborNotifyEvent event) {
        if (!active) {
            return;
        }
        LevelAccessor level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        BlockPos pos = event.getPos();
        if (!Logic37.isManaged((ResourceKey<Level>)sl.dimension(), pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (!Logic37.isAnyRedstoneTorch(state)) {
            Logic37.unmarkManaged((ResourceKey<Level>)sl.dimension(), pos);
            return;
        }
        if (state.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            sl.setBlock(pos, Logic37.forceOff(state), 3);
        }
    }

    private static boolean isAnyTorch(BlockState state) {
        return state.is(Blocks.TORCH) || state.is(Blocks.WALL_TORCH) || state.getBlock() instanceof TorchBlock || state.getBlock() instanceof WallTorchBlock;
    }

    private static boolean isAnyRedstoneTorch(BlockState state) {
        return state.is(Blocks.REDSTONE_TORCH) || state.is(Blocks.REDSTONE_WALL_TORCH);
    }

    private static BlockState forceOff(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.LIT)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.FALSE);
        }
        return state;
    }

    private static void markManaged(ResourceKey<Level> dim, BlockPos pos) {
        MANAGED.computeIfAbsent(dim, d -> new HashSet()).add(pos.immutable());
    }

    private static boolean isManaged(ResourceKey<Level> dim, BlockPos pos) {
        Set<BlockPos> set = MANAGED.get(dim);
        return set != null && set.contains(pos);
    }

    private static void unmarkManaged(ResourceKey<Level> dim, BlockPos pos) {
        Set<BlockPos> set = MANAGED.get(dim);
        if (set != null) {
            set.remove(pos);
            if (set.isEmpty()) {
                MANAGED.remove(dim);
            }
        }
    }

    private static void pruneManaged(ServerLevel level) {
        ResourceKey dim = level.dimension();
        Set<BlockPos> set = MANAGED.get(dim);
        if (set == null || set.isEmpty()) {
            return;
        }
        Iterator<BlockPos> it = set.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            BlockState st = level.getBlockState(pos);
            if (!Logic37.isAnyRedstoneTorch(st)) {
                it.remove();
                continue;
            }
            if (!st.hasProperty((Property)BlockStateProperties.LIT) || !((Boolean)st.getValue((Property)BlockStateProperties.LIT)).booleanValue()) continue;
            level.setBlock(pos, Logic37.forceOff(st), 3);
        }
        if (set.isEmpty()) {
            MANAGED.remove(dim);
        }
    }
}

