/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

public class Logic38 {
    private static final double MIN_GAMMA = 0.0;
    private static int saveTickCounter = 0;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic38());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        Double current;
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.options == null) {
            return;
        }
        OptionInstance gammaOpt = mc.options.gamma();
        if (gammaOpt != null && ((current = (Double)gammaOpt.get()) == null || current != 0.0)) {
            gammaOpt.set((Object)0.0);
            if (saveTickCounter++ % 40 == 0) {
                mc.options.save();
                if (saveTickCounter > 120000) {
                    saveTickCounter = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public void onAnyScreenOpen(ScreenEvent.Opening event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.options == null) {
            return;
        }
        OptionInstance gammaOpt = mc.options.gamma();
        if (gammaOpt != null && (Double)gammaOpt.get() != 0.0) {
            gammaOpt.set((Object)0.0);
            mc.options.save();
        }
    }

    public static void registerMod(IEventBus modEventBus) {
        modEventBus.addListener(Logic38::onRegisterGuiLayers);
    }

    public static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"complicatedminecraftmod", (String)"extra_dark_overlay"), (gfx, delta) -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.level == null) {
                return;
            }
            if (mc.screen != null && mc.screen.isPauseScreen()) {
                return;
            }
            long time = mc.level.getDayTime() % 24000L;
            float nightFactor = Logic38.computeNightFactor(time);
            if (nightFactor <= 0.001f) {
                return;
            }
            float alpha = 0.6f * nightFactor;
            int a = (int)(alpha * 255.0f) & 0xFF;
            int color = a << 24;
            int w = gfx.guiWidth();
            int h = gfx.guiHeight();
            gfx.fill(0, 0, w, h, color);
        });
    }

    private static float computeNightFactor(long time) {
        if (time < 12000L) {
            return 0.0f;
        }
        if (time < 14000L) {
            return (float)(time - 12000L) / 2000.0f;
        }
        if (time < 22000L) {
            return 1.0f;
        }
        if (time < 24000L) {
            return 1.0f - (float)(time - 22000L) / 2000.0f;
        }
        return 0.0f;
    }
}

